/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyExcelExportServiceImpl.java   2020-10-15 14-28-36
 * Author: Evan
 */
package com.xforceplus.business.company.service.impl;

import com.xforceplus.api.model.CompanyModel.Request.Query;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.company.CompanyConfigDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.entity.Company;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

import static com.xforceplus.business.company.service.CompanyConfigExcel.SN_COMPANY_CONFIG;
import static com.xforceplus.business.company.service.CompanyConfigExcel.SORT_FIELD;
import static com.xforceplus.business.excel.ExcelFile.*;
import static org.springframework.data.domain.Sort.Direction.DESC;

/**
 * <p>
 * Title:  CompanyExcelExportServiceImpl
 * </p>
 * <p>
 * Description: CompanyExcelExportServiceImpl
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-15 14-28-36
 * @since V1.0
 */
@Service
public class CompanyConfigExcelExportServiceImpl implements ExcelWriteService {

    private final CompanyService companyService;

    public CompanyConfigExcelExportServiceImpl(CompanyService companyService) {
        this.companyService = companyService;
    }

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_CONFIG_EXCEL_FILE;
    }


    /**
     * 导入定义
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public void write(Context context) {
        Query query = context.getParam(PARAMS_QUERY, Query.class);
        Sort sort = context.getParam(PARAMS_SORT, Sort.class);
        List<String> sheetNames = Arrays.asList(query.getSheets());
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        for (String sheetName : sheetNames) {
            //等于公司服务配置信息，则分页读取公司信息
            if (SN_COMPANY_CONFIG.equals(sheetName)) {
                Page<Company> page;
                Pageable pageable = PageRequest.of(START_PAGE, PAGE_SIZE, sort.and(Sort.by(DESC, SORT_FIELD)));
                do {
                    page = this.companyService.page(query, pageable);
                    //对象转换
                    Page<CompanyConfigDTO> configPageDTO = page.map(e -> {
                        CompanyConfigDTO dto = new CompanyConfigDTO();
                        dto.setCompanyName(e.getCompanyName());
                        dto.setCompanyTax(StringUtils.trimToEmpty(e.getTaxNum()));
                        dto.setInspectionServiceFlag(String.valueOf(e.getInspectionServiceFlag()));
                        dto.setTraditionAuthenFlag(String.valueOf(e.getTraditionAuthenFlag()));
                        dto.setSpeedInspectionChannelFlag(String.valueOf(e.getSpeedInspectionChannelFlag()));

                        return dto;
                    });
                    simpleExcelWriter.fill(sheetName, configPageDTO.getContent());
                    pageable = pageable.next();
                } while (page.hasNext() && page.getNumber() < maxPageSize);
                //计算当前导出数据  this.calcSuccessSize(page,)
                simpleExcelWriter.param(SUCCESS_SIZE, this.calcSuccessSize(page));
            }

        }
    }
}
