package com.xforceplus.business.company.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.business.company.service.CompanyServicePackageService;
import com.xforceplus.business.enums.ActionTypeEnum;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.company.CompanyPackageDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.entity.CompanyServiceRel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author zhouxin
 */
@SuppressWarnings("AlibabaServiceOrDaoClassShouldEndWithImpl")
@Slf4j
@Service
public class CompanyPackageImportServiceImpl implements ExcelReaderService {

    @Autowired
    protected TenantService tenantService;
    @Autowired
    private CompanyServicePackageService companyServicePackageService;
    @Autowired
    private CompanyServiceRelDao companyServiceRelDao;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_PACKAGE_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            //构建监听器
            AnalysisEventListener<CompanyPackageDTO> excelDataListener = SimpleDataReadListener
                    .listener(context, (rows) -> {
                        this.saveCompanyPackageData(messageRows, context, rows);
                    });
            //开始处理
            context.getSimpleExcelReader().read(CompanyPackageDTO.class, excelDataListener);
        }
        return context;
    }

    public void saveCompanyPackageData(MessageRow messageRows, Context context, List<CompanyPackageDTO> list) {
        for (CompanyPackageDTO e : list) {
            try {
                if (!e.getValidatedStatus()) {
                    messageRows.fail(e.getRowIndex(), e.getValidatedMessage());
                    continue;
                }

                if (ActionTypeEnum.BIND.getActionCode().equals(e.getAction())) {
                    List<CompanyServiceRel> companyServiceRel = companyServiceRelDao.findByTenantCodeAndTaxNumAndPackageCode(e.getTenantCode(), e.getTaxNum(), e.getPackageCode());
                    if (!CollectionUtils.isEmpty(companyServiceRel)) {
                        messageRows.fail(e.getRowIndex(), "记录已存在，跳过不处理");
                        continue;
                    }
                    companyServicePackageService.bindCompanyAndPackage(e.getTenantCode(), e.getTaxNum(), e.getPackageCode(), 1, false);
                } else if (ActionTypeEnum.UNBIND.getActionCode().equals(e.getAction())) {
                    List<CompanyServiceRel> companyServiceRels = companyServiceRelDao.findByTenantCodeAndTaxNumAndPackageCode(e.getTenantCode(), e.getTaxNum(), e.getPackageCode());
                    if (!CollectionUtils.isEmpty(companyServiceRels)) {
                        for (CompanyServiceRel companyServiceRel : companyServiceRels) {
                            companyServicePackageService.unbindCompanyPackages(companyServiceRel.getId());
                        }
                    } else {
                        messageRows.fail(e.getRowIndex(), "非法的租户代码或者社会信用代码或者产品服务包代码");
                        continue;
                    }
                } else {
                    messageRows.fail(e.getRowIndex(), "操作方式非法");
                }
                messageRows.success(e.getRowIndex());
            } catch (Exception ex) {
                messageRows.fail(e.getRowIndex(), ex.getMessage());
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}
