package com.xforceplus.business.conf.controller;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.business.conf.dto.SaasConfigDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chenpengpeng@xforceplus.com
 * @date 2021/6/11
 **/
@RestController
public class SaasMenuConfigController implements Uri {
    @Value("${saas.taxware.enabled:true}")
    private boolean enableTaxware;

    @ApiOperation("获取saas全局菜单配置")
    @GetMapping(PATH_CURRENT_PREFIX + "/saas/config")
    public ResponseEntity<SaasConfigDto> getSaasConfig() {
        SaasConfigDto saasConfigDto = new SaasConfigDto();
        saasConfigDto.setEnableTaxwareMenu(enableTaxware);
        return ResponseEntity.ok(saasConfigDto);
    }
}
