package com.xforceplus.business.conf.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.SysEnumModel.Query;
import com.xforceplus.api.model.SysEnumModel.Save;
import com.xforceplus.api.model.SysEnumModel.Update;
import com.xforceplus.business.conf.service.SysEnumService;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.entity.SysEnum;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author HWT
 * @since  2022/1/6 16:41
 */
@Validated
@RestController
public class SysEnumController implements Uri {

    private SysEnumService sysEnumService;

    public SysEnumController(SysEnumService sysEnumService) {
        this.sysEnumService = sysEnumService;
    }

    @ApiOperation("分页查询枚举值信息")
    @JsonView(View.class)
    @GetMapping(PATH_GLOBAL_PREFIX + "/sys-enum/page")
    public ResponseEntity<Page<SysEnum>> page(@SpringQueryMap Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory
            .ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));
        Page<SysEnum> page = sysEnumService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation("查询一组枚举值信息")
    @GetMapping(PATH_GLOBAL_PREFIX + "/sys-enum/enum-group")
    @JsonView(View.class)
    public ResponseEntity<List<SysEnum>> getEnumGroup(@RequestParam( value = "enumGroupName", required = true)  String enumGroupName) {
        List<SysEnum> enumList = sysEnumService.getByEnumGroupName(enumGroupName);
        return ResponseEntity.ok(enumList);
    }

    @ApiOperation("刪除一组枚举值")
    @DeleteMapping(PATH_GLOBAL_PREFIX + "/sys-enum/enum-group")
    public ResponseEntity<String> deleteByGroupName(@RequestParam( value = "enumGroupName", required = true)  String enumGroupName) {
        sysEnumService.deleteByGroupName(enumGroupName);
        return ResponseEntity.ok();
    }


    @ApiOperation("删除单个枚举值信息")
    @DeleteMapping(PATH_GLOBAL_PREFIX + "/sys-enum/enum-item/{id}")
    public ResponseEntity<String>deleteSysEnum(@PathVariable("id") long id) {
        sysEnumService.delete(id);
        return ResponseEntity.ok();
    }

    @ApiOperation("新增枚举值信息")
    @PostMapping(PATH_GLOBAL_PREFIX + "/sys-enum/enum-item")
    public ResponseEntity<SysEnum> addSysEnum(@RequestBody @Validated(ValidationGroup.OnCreate.class) Save model) {
        SysEnum sysEnum = sysEnumService.add(model);
        return ResponseEntity.ok(sysEnum);
    }

    @ApiOperation("更新枚举值信息")
    @PutMapping(PATH_GLOBAL_PREFIX + "/sys-enum/enum-item")
    public ResponseEntity<SysEnum> updateSysEnum(@RequestBody @Validated(ValidationGroup.OnCreate.class) Update model) {
        SysEnum sysEnum = sysEnumService.update(model);
        return ResponseEntity.ok(sysEnum);
    }

}
