package com.xforceplus.business.conf.service;


import com.xforceplus.api.model.SysEnumModel.Query;
import com.xforceplus.api.model.SysEnumModel.Save;
import com.xforceplus.api.model.SysEnumModel.Update;
import com.xforceplus.dao.SysEnumDao;
import com.xforceplus.entity.SysEnum;
import com.xforceplus.query.SysEnumQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author HWT
 * @since 2022/1/19 19:37
 */
@Service
public class SysEnumService {

    private final SysEnumDao sysEnumDao;

    public SysEnumService(SysEnumDao sysEnumDao) {
        this.sysEnumDao = sysEnumDao;
    }

    public List<SysEnum> getByEnumGroupName(String enumGroupName) {
        return sysEnumDao.findByEnumGroupName(enumGroupName);
    }


    public Page<SysEnum> page(Query query, Pageable pageable) {
        Page<SysEnum> page = sysEnumDao.findAll(SysEnumQueryHelper.querySpecification(query), pageable);
        return page;
    }

    public SysEnum add(Save model) {
        Query query = new Query();
        query.setEnumGroupName(model.getEnumGroupName());
        query.setEnumName(model.getEnumName());
        List<SysEnum> sysEnumList = sysEnumDao.findAll(SysEnumQueryHelper.querySpecification(query));
        if (CollectionUtils.isNotEmpty(sysEnumList)) {
            throw new IllegalArgumentException("信息已经存在:" + model.getEnumGroupName());
        }

        SysEnum sys = new SysEnum();
        sys.setEnumGroupName(model.getEnumGroupName());
        sys.setEnumName(model.getEnumName());
        sys.setEnumValue(model.getEnumValue());
        sys.setEnumSeq(model.getEnumSeq());
        sys.setEnumType(model.getEnumType());
        return sysEnumDao.saveAndFlush(sys);
    }


    public SysEnum update(Update model) {
        Optional<SysEnum> sysEnumOptional = sysEnumDao.findById(model.getId());
        if (!sysEnumOptional.isPresent()) {
            throw new IllegalArgumentException("信息不存在:" + model.getEnumGroupName());
        }
        SysEnum existEntity = sysEnumOptional.get();
        BeanUtils.copyProperties(model, existEntity);
        return sysEnumDao.saveAndFlush(existEntity);
    }

    public void deleteByGroupName(String enumGroupName) {
        Query query = new Query();
        query.setEnumGroupName(enumGroupName);
        List<SysEnum> sysEnumList = sysEnumDao.findAll(SysEnumQueryHelper.querySpecification(query));
        if (CollectionUtils.isEmpty(sysEnumList)) {
            throw new IllegalArgumentException("信息不存在:" + enumGroupName);
        }
        sysEnumList.stream().forEach(sysEnumDao::delete);
    }

    public void delete(long id) {
        Optional<SysEnum> sysEnumOptional = sysEnumDao.findById(id);
        if (!sysEnumOptional.isPresent()) {
            throw new IllegalArgumentException("信息不存在:" + id);
        }
        sysEnumDao.deleteById(id);
    }

}

