package com.xforceplus.business.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.util.Collection;
import java.util.List;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public interface BaseEnum<T> {
    T getValue();

    static <E extends Enum<E> & BaseEnum<T>, T> boolean isValid(Class<E> clazz, T value) {
        return getEnum(clazz, value) != null;
    }

    static <E extends Enum<E> & BaseEnum<T>, T> E getEnum(@NonNull Class<E> clazz, T value) {
        return value == null ? null : EnumUtils.getEnumList(clazz).stream()
                .filter(c -> value.equals(c.getValue())).findFirst().orElse(null);
    }

    static <E extends Enum<E> & BaseEnum<T>, T> E getEnum(@NonNull Class<E> clazz, Collection<T> value, E defaultEnum) {
        if (value == null || CollectionUtils.isEmpty(value)) {
            return defaultEnum;
        }
         return   EnumUtils.getEnumList(clazz).stream()
                .filter(c -> value.contains(c.getValue())).findFirst().orElse(defaultEnum);
    }


     static  <E extends Enum<E> & BaseEnum<T>, T> String enumToString(Class<E> e) throws JsonProcessingException {
         List<E> d1 =  EnumUtils.getEnumList(e);
         return Jackson2ObjectMapperBuilder.json().build().writeValueAsString(d1);
    }

}
