package com.xforceplus.business.enums;

/**
 * @author libaozhong
 */
public interface DidiAccountEnum {
    /**
     * 校验状态
     */
    enum Status {
        //成功
        SUCCESS(0, "成功"),
        //失败
        FAIL(1, "失败"),
        //签名不合法
        SIGN_ILLEGAL(200012, "签名不合法"),
        //各种的参数校验异常（不包括签名错误）
        CHECK_FAIL(200001, "各种的参数校验异常（不包括签名错误）");
        private int value;
        private String name;

        Status(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int value() {
            return this.value;
        }


    }
}
