/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: BusinessAttribute.java   2020-10-15 14-33-33
 * Author: Evan
 */
package com.xforceplus.business.excel;

import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * <p>
 * Title:  业务属性
 * </p>
 * <p>
 * Description: 业务属性
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-15 14-33-33
 * @since V1.0
 */
@Getter
public class BusinessAttribute {
    /**
     * 业务名称
     */
    private String name;

    /**
     * 导出模板
     */
    private String exportTemplateFile;

    /**
     * 导入模板
     */
    private String importTemplateFile;
    /**
     * SheetSize
     */
    private Integer batchSize;

    /**
     * Sheets
     */
    private List<ExcelSheet> sheets;

    /**
     * 默认构建函数
     *
     * @param name
     * @param exportTemplateFile
     * @param importTemplateFile
     * @param batchSize
     * @param sheets
     */
    protected BusinessAttribute(String name, String exportTemplateFile, String importTemplateFile, Integer batchSize, List<ExcelSheet> sheets) {
        this.name = name;
        this.exportTemplateFile = exportTemplateFile;
        this.importTemplateFile = importTemplateFile;
        this.batchSize = batchSize;
        this.sheets = sheets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String exportTemplateFile;
        private String importTemplateFile;
        private Integer batchSize;
        private List<ExcelSheet> sheets;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder exportTemplateFile(String exportTemplateFile) {
            this.exportTemplateFile = exportTemplateFile;
            return this;
        }

        public Builder importTemplateFile(String importTemplateFile) {
            this.importTemplateFile = importTemplateFile;
            return this;
        }

        public Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder sheets(List<ExcelSheet> sheets) {
            this.sheets = sheets;
            return this;
        }

        public BusinessAttribute build() {
            if (StringUtils.isBlank(name)) {
                throw new IllegalArgumentException("业务名称不能为空");
            }

            if (StringUtils.isBlank(this.exportTemplateFile)) {
                throw new IllegalArgumentException("导出模板路径不能为空");
            }
            if (CollectionUtils.isEmpty(this.sheets)) {
                throw new IllegalArgumentException("导入或导出Excel的Sheet不能为空");
            }
            return new BusinessAttribute(name, exportTemplateFile, importTemplateFile, batchSize, sheets);
        }
    }
}
