/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: BusinessType.java   2020-09-22 11-40-54
 * Author: Evan
 */
package com.xforceplus.business.excel;

import java.util.List;

/**
 * <p>
 * Title: 导入业务类型
 * </p>
 * <p>
 * Description: 导入业务类型
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 11-40-54
 * @since V1.0
 */
public interface BusinessType {
    /**
     * 业务名称
     *
     * @return String
     */
    String getBusinessName();

    /**
     * 获取业务类型
     *
     * @return String
     */
    String getName();

    /**
     * 设置每批读取大小
     * @return BatchSize
     */
    Integer batchSize();

    /**
     * 获取模板名称
     *
     * @return String
     */
    String getExportTemplateFile();

    /**
     * 获取Sheets列表
     *
     * @return List<String> sheetName
     */
    List<ExcelSheet> sheets();
}
