/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: DataRow.java   2020-09-22 22-43-49
 * Author: Evan
 */
package com.xforceplus.business.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * <p>
 * Title: DataRow索引
 * </p>
 * <p>
 * Description:  DataRow索引
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 22-43-49
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class DataRow implements Serializable {

    /**
     * 当前RowIndex
     */
    @ExcelIgnore
    protected Integer rowIndex;

    /**
     * 校验状态(true,代码成功，false代表失败)
     */
    @ExcelIgnore
    protected Boolean validatedStatus;
    /**
     * 校验消息是否成功
     */
    @ExcelIgnore
    protected String validatedMessage;
}
