/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelConfig.java   2020-09-27 18-07-33
 * Author: Evan
 */
package com.xforceplus.business.excel;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.text.MessageFormat;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-27 18-07-33
 * @since V1.0
 */
@SuppressWarnings("all")
@Configuration
@ConfigurationProperties(prefix = "excel.file.download")
public class ExcelConfig implements ApplicationContextAware {
    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(ExcelConfig.class);
    private static ExcelConfig excelConfig;
    @Value("${excel.file.download.url}")
    private String url;
    /**
     * Path Prefix API {@value}
     */
    @Value("${xforce.tenant.service.url.prefix:/api}")
    private String pathPrefix;
    /**
     * API Version {@value}
     */
    @Value("${xforce.tenant.service.api.version}")
    private String apiVersion;
    /**
     * API Version {@value} 默认为:1
     */
    @Value("${excel.notice.appId:1}")
    private Long appId;
    private String httpUrl;
    /**
     * Excel导出限制最大行数
     */
    @Value("${excel.export.limit.max.size:5000}")
    private Integer limitMaxSize;
    /**
     * Excel导出限制最大行数
     */
    @Value("${excel.max.rerun.read.time:3}")
    private Integer maxRerunReadTime;

    private int expiredDay = 3;
    /**
     * ApplicationContext
     */
    private ApplicationContext applicationContext;

    /**
     * 最大限制重跑次数
     *
     * @return Integer 最大限制重跑次数
     */
    public static Integer getMaxRerunReadTime() {
        return excelConfig.maxRerunReadTime;
    }

    /**
     * 导出出限制大行数
     *
     * @return Long
     */
    public static Integer getLimitMaxSize() {
        return excelConfig.limitMaxSize;
    }

    /**
     * 获取URL
     * @return 地址
     */
    public static String getDownloadUrl() {
        return excelConfig.httpUrl;
    }

    /**
     * 文件效期
     *
     * @return int
     */
    public static int getExpiredDay() {
        return excelConfig.expiredDay;
    }

    /**
     * ExcelFile 发送消息
     *
     * @return Long
     */
    public static Long getAppId() {
        return excelConfig.appId;
    }

    @PostConstruct
    public void init() {
        excelConfig = this;
        try {
            if (StringUtils.isBlank(apiVersion)) {
                this.apiVersion = StringUtils.EMPTY;
            }
            excelConfig.httpUrl = MessageFormat.format(url, this.pathPrefix, this.apiVersion);
            excelConfig.httpUrl = StringUtils.lowerCase(excelConfig.httpUrl);
            logger.info("excelConfig.httpUrl:{}", this.httpUrl);
        } catch (Exception e) {
            logger.error(e.getMessage(), e.getCause());
        }
    }

    /**
     * 注入 Spring ApplicationContext
     *
     * @param applicationContext ApplicationContext
     * @throws BeansException
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
