/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelFile.java   2020-09-17 14-48-48
 * Author: Evan
 */
package com.xforceplus.business.excel;

import io.geewit.utils.uuid.UUIDUtils;
import org.apache.commons.lang3.StringUtils;

import java.nio.file.Paths;

/**
 * <p>
 * Title: ExcelFile 常理定义
 * </p>
 * <p>
 * Description: ExcelFile 常理定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-17 14-48-48
 * @since V1.0
 */
@SuppressWarnings("all")
public final class ExcelFile {
    /**
     * Excel 2007以后版扩展名：{@value}
     */
    public static final String FILE_NAME_EXT = ".xlsx";


    /**
     * user.dir临时目录
     */
    public static final String TMP_DIR = "user.dir";
    /**
     * 启始页
     */
    public static final int START_PAGE = 0;
    /**
     * 默认导入每页1000{@value}
     */
    public static final int PAGE_SIZE = 1000;
    /**
     * 限制导出的最大行数为：10万行；
     */
    public static final int MAX_SIZE = 5000 / PAGE_SIZE;

    /**
     * 总数量
     */
    public static final String TOTAL_SIZE = "TOTAL_SIZE";
    /**
     * 成功数据
     */
    public static final String SUCCESS_SIZE = "SUCCESS_SIZE";
    /**
     * 导入数据
     */

    public static final String EXCEPTION_MESSAGE = "EXCEPTION_MESSAGE";
    /**
     * 失败的数据
     */
    public static final String FAIL_SIZE = "FAIL_SIZE";

    /**
     * 显示SheetMessageKey
     */
    public static final String SHEET_MESSAGE_KEY = "SHEET_MESSAGE_KEY";
    /**
     * 零行记录
     */
    public static final int ZERO_SIZE = 0;
    /**
     * SheetMessage 默认消息格式
     */
    public static final String SHEET_MESSAGE = "【{0}】导入的总数为:{1}条数据，成功导入为：{2}条数据，失败导入为:{3}条数据";
    /**
     * SheetSize
     */
    public static final String SHEET_SIZE = "SHEET_SIZE";
    /**
     * 是否部分成功
     */
    public static final String RESULT_STATE = "RESULT_STATE";
    /**
     * EXCEL_IMPORT_POOL_NAME
     */
    public static final String EXCEL_IMPORT_POOL_NAME = "excel-import-pool-";

    /**
     * 查询条件参数：{@value}
     */
    public static final String PARAMS_QUERY = "P_QUERY";


    /**
     * 排序条件参数：{@value}
     */
    public static final String PARAMS_SORT = "P_SORT";


    /**
     * 排序条件参数：{@value}
     */
    public static final String PARAMS_PAGEABLE = "P_PAGEABLE";

    /**
     * 导出
     */
    public static final String EXPORT_TEXT = "导出";

    /**
     * 导出
     */
    public static final String IMPORT_TEXT = "导入";
    /**
     * 导出
     */
    public static final String IMPORT_RESULT_TEXT = "导入结果";

    /**
     * 创建Excel文件的路径
     * @return String 全路径+文件名
     */
    public static String createExcelFilePath() {
        return Paths.get(System.getProperties().getProperty(ExcelFile.TMP_DIR),
                StringUtils.upperCase(UUIDUtils.randomUUID()) + ExcelFile.FILE_NAME_EXT)
                .toString();
    }

}
