/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelImportProcess.java   2020-09-22 15-09-10
 * Author: Evan
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.reader.Context;

/**
 * <p>
 * Title: ExcelImportProcess处理
 * </p>
 * <p>
 * Description: ExcelImportProcess处理
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 15-09-10
 * @since V1.0
 */
public interface ExcelProcess {

    /**
     * 文件处理前
     * @param context 处理上下文
     */
    void before(Context context);

    /**
     * 读取数据
     *
     * @param context 上下文
     */
    void process(Context context);


    /**
     * 文件处理前
     * @param context 处理上下文
     */
    void after(Context context);
}
