/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelImportConfiguration.java   2020-09-22 14-35-37
 * Author: Evan
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.reader.ExcelReaderUtils;
import com.xforceplus.business.excel.writer.ExcelWriteUtils;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.service.ExcelWriteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * <p>
 * Title: 注入Validation
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 14-35-37
 * @since V1.0
 */
@Slf4j
@Configuration
@SuppressWarnings("all")
public class ExcelServiceConfiguration implements InitializingBean, DisposableBean {

    /**
     *  ApplicationContext
     */
    private final ApplicationContext applicationContext;

    public ExcelServiceConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /**
     * Clear Mp
     *
     * @throws Exception in case of shutdown errors. Exceptions will get logged
     *                   but not rethrown to allow other beans to release their resources as well.
     */
    @Override
    public void destroy() throws Exception {
        ExcelReaderUtils.clear();
        ExcelWriteUtils.clear();
    }

    /**
     * 注入ReaderService
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, ExcelReaderService> beans = applicationContext.getBeansOfType(ExcelReaderService.class);
        if (CollectionUtils.isEmpty(beans)) {
            return;
        }
        for (Map.Entry<String, ExcelReaderService> entry : beans.entrySet()) {
            //处理
            ExcelReaderUtils.put(entry.getValue().getBusinessType(), entry.getValue());

            ExcelReaderUtils.putHeader(entry.getValue().getBusinessType(),entry.getValue().getSheetHeaderNumber());

        }


        Map<String, ExcelWriteService> writeServiceMap = applicationContext.getBeansOfType(ExcelWriteService.class);
        if (CollectionUtils.isEmpty(writeServiceMap)) {
            return;
        }
        for (Map.Entry<String, ExcelWriteService> entry : writeServiceMap.entrySet()) {
            //处理
            ExcelWriteUtils.put(entry.getValue().getBusinessType(), entry.getValue());
        }
    }
}
