/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelSheetDTO.java   2020-09-17 13-37-34
 * Author: Evan
 */
package com.xforceplus.business.excel;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * Title: Excel Sheet
 * </p>
 * <p>
 * Description: Excel Sheet
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-17 13-37-34
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class ExcelSheet {
    /**
     * 工作名名称No
     */
    private Integer sheetNo;
    /**
     * 工作表名称
     */
    private String sheetName;
    /**
     * 工作名称
     */
    private List<?> data;

    /**
     * 当前导入数据量
     */
    private Integer size;

    public ExcelSheet() {
        this.data = Collections.emptyList();
        this.size = Integer.MIN_VALUE;
    }

    /**
     * 构建 SheetName
     *
     * @param sheetNo   SheetNo
     * @param sheetName SheetName
     */
    public ExcelSheet(Integer sheetNo, String sheetName) {
        this();
        this.sheetNo = sheetNo;
        this.sheetName = sheetName;


    }

    /**
     * 所有有
     *
     * @param sheetNo   sheetNO
     * @param sheetName SheetName
     * @param data      Data
     */
    public ExcelSheet(Integer sheetNo, String sheetName, List<?> data) {
        this(sheetNo, sheetName);
        this.data = data;
        this.size = Integer.MIN_VALUE;
    }
}
