/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelValidator.java   2020-09-24 15-40-30
 * Author: Evan
 */
package com.xforceplus.business.excel;

import com.google.common.base.Joiner;
import com.xforceplus.api.utils.Separator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * <p>
 * Title: 基于Excel Vo对象校验器
 * </p>
 * <p>
 * Description: 基于Excel Vo对象校验器
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-24 15-40-30
 * @since V1.0
 */
@Component
@SuppressWarnings("all")
public class ExcelValidator {
    /**
     * 获取校验器
     */
    private static Validator VALIDATOR;

    /**
     * Excel数据校验器
     * @param obj 对象 校验对象
     */
    public static <T> void validate(T obj) {

        Set<ConstraintViolation<T>> constraintViolations = VALIDATOR.validate(obj, Default.class);
        if (obj instanceof DataRow) {
            DataRow dataRow = (DataRow) obj;
            if (CollectionUtils.isEmpty(constraintViolations)) {
                dataRow.setValidatedStatus(Boolean.TRUE);
                return;
            }
            List<String> messages = constraintViolations.stream()
                    .map(ConstraintViolation::getMessage)
                    .collect(Collectors.toCollection(() -> new ArrayList<>(constraintViolations.size())));
            //将消息拼接一起来。
            String message = Joiner.on(Separator.SEMICOLON + "\r\n").skipNulls().join(messages);
            dataRow.setValidatedStatus(Boolean.FALSE);
            dataRow.setValidatedMessage(message);
        }
    }

    /**
     * 注入获取校验器
     *
     * @param validator Validator
     */
    @Autowired
    public void setValidator(Validator validator) {
        VALIDATOR = validator;
    }
}
