/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: QueryParam.java   2020-10-15 16-26-12
 * Author: Evan
 */
package com.xforceplus.business.excel;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-15 16-26-12
 * @since V1.0
 */
public class QueryParam {

    private Map<String, Object> params;


    private QueryParam(Map<String, Object> params) {
        this.params = params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> params() {
        return params;
    }

    public static class Builder {
        private Map<String, Object> params;

        public Builder() {
            params = new HashMap<>(3);
        }

        public Builder param(Map<String, Object> params) {
            this.params.putAll(params);
            return this;
        }

        public Builder param(String key, Object value) {
            this.params.put(key, value);
            return this;
        }

        public QueryParam build() {
            return new QueryParam(this.params);
        }

    }

}
