package com.xforceplus.business.excel.company;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;

/**
 * @author wanglijun
 */
@Setter
@Getter
@ToString
public class CompanyConfigDTO extends DataRow {
    /**
     * 操作
     */
    @ExcelProperty(value = "操作")
    protected String action;
    /**
     * 公司名称
     */
    @ExcelProperty(value = "公司名称")
    private String companyName;

    @ExcelProperty("统一社会信用代码")
    @NotBlank(message = "统一社会信用代码不能为空")
    private String companyTax;

    @ExcelProperty("传统认证")
    @NotBlank(message = "传统认证不能为空")
    @Max(value = 1, message = "不合法的传统认证值，范围【1，0】")
    @Min(value = 0, message = "不合法的传统认证值，范围【1，0】")
    private String traditionAuthenFlag;

    @ExcelProperty("查验服务")
    @NotBlank(message = "查验服务不能为空")
    @Max(value = 1, message = "不合法的查验服务值，范围【1，0】")
    @Min(value = 0, message = "不合法的查验服务值，范围【1，0】")
    private String inspectionServiceFlag;

    @ExcelProperty("极速查验通道")
    @NotBlank(message = "极速查验通道不能为空")
    @Max(value = 1, message = "不合法的极速查验通道值，范围【1，0】")
    @Min(value = 0, message = "不合法的极速查验通道值，范围【1，0】")
    private String speedInspectionChannelFlag;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setCompanyTax(String companyTax) {
        this.companyTax = StringUtils.trim(companyTax);
    }

    public void setTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = StringUtils.trim(traditionAuthenFlag);
    }

    public void setInspectionServiceFlag(String inspectionServiceFlag) {
        this.inspectionServiceFlag = StringUtils.trim(inspectionServiceFlag);
    }

    public void setSpeedInspectionChannelFlag(String speedInspectionChannelFlag) {
        this.speedInspectionChannelFlag = StringUtils.trim(speedInspectionChannelFlag);
    }
}
