/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyExcelDTO.java   2020-09-22 10-23-50
 * Author: Evan
 */
package com.xforceplus.business.excel.company;

import com.xforceplus.business.excel.DataRow;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * Title: 公司批量导出Excel类
 * </p>
 * <p>
 * Description: 公司批量导出Excel类
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 10-23-50
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class CompanyExcelDTO extends DataRow implements Serializable {
    /**
     * 租户名称
     */
    protected String tenantName;
    /**
     * 租户代码
     */
    protected String tenantCode;
    /**
     * 企业注册省份
     */
    protected String registLocationArea;
    /**
     * 企业注册城市
     */
    protected String registLocationCity;
    /**
     * 企业注册详细地址
     */
    protected String registLocationAddr;
    /**
     * 公司经营所在省份
     */
    protected String locationArea;
    /**
     * 公司经营所在市区
     */
    protected String locationCity;
    /**
     * 公司经营详细地址
     */
    protected String locationAddr;
    /**
     * 公司经营电话
     */
    protected String companyPhone;
    /**
     * 营业期限开始时间
     */
    protected Date businessStartTime;
    /**
     * 营业期限结束时间
     */
    protected Date businessEndTime;
    /**
     * 营业时间是否长期
     */
    protected Integer businessTimeLong;
    /**
     * 企业经营范围
     */
    protected String businessScope;
    /**
     * 平台管理人身份,0:法定代表人, 1:代理人
     */
    protected Integer platManagerStatus;
    /**
     * 法人归属地
     */
    protected String managerLocation;
    /**
     * 法人姓名
     */
    protected String managerName;
    /**
     * 法人证件开始时间
     */
    protected Date managerIdCardStartTime;
    /**
     * 法人证件结束时间
     */
    protected Date managerIdCardEndTime;
    /**
     * 法人身份证长期
     */
    protected Integer managerIdCardTimeLong;
    /**
     * 法人证件类型  1-身份证
     */
    protected String managerCardType;
    /**
     * 法人身份证
     */
    protected String managerIdCard;
    /**
     * 法人联系方式
     */
    protected String managerPhone;
    /**
     * 代理人姓名
     */
    protected String proxyManagerName;
    /**
     * 代理人证件开始时间
     */
    protected Date proxyManagerIdCardStartTime;
    /**
     * 代理人证件结束时间
     */
    protected Date proxyManagerIdCardEndTime;
    /**
     * 代理人身份证长期
     */
    protected Integer proxyManagerIdCardTimeLong;
    /**
     * 代理人证据类型  1-身份证
     */
    protected String proxyManagerCardType;
    /**
     * 代理人身份证
     */
    protected String proxyManagerIdCard;
    /**
     * 代理人联系方式
     */
    protected String proxyManagerPhone;
    /**
     * 开户行名称
     */
    protected String bankName;
    /**
     * 开户银行支行名称
     */
    protected String bankBranchName;
    /**
     * 对公银行账户
     */
    protected String bankNo;
    /**
     * 纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人
     */
    protected Integer taxpayerQualificationType;
    /**
     * 增值税普通发票限额
     */
    protected BigDecimal cquota;
    /**
     * 增值税专用发票限额
     */
    protected BigDecimal squota;
    /**
     * 增值税电子普通发票限额
     */
    protected BigDecimal ceQuota;
    /**
     * 增值税普通发票-卷票限额
     */
    protected BigDecimal juQuota;
    /**
     * 增值税电子专票限额
     */
    protected BigDecimal seQuota;

   /**
    * 机动车发票限额
    */
    protected BigDecimal vehicleLimit;

    /**
     * 公司ID
     */
    private Long companyId;
    /**
     * 公司
     */
    private String companyCode;
    /**
     * 企业名称
     */
    private String companyName;
    /**
     * 税号
     */
    private String taxNum;

    public void setTenantName(String tenantName) {
        this.tenantName = StringUtils.trim(tenantName);
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = StringUtils.trim(tenantCode);
    }

    public void setRegistLocationArea(String registLocationArea) {
        this.registLocationArea = StringUtils.trim(registLocationArea);
    }

    public void setRegistLocationCity(String registLocationCity) {
        this.registLocationCity = StringUtils.trim(registLocationCity);
    }

    public void setRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = StringUtils.trim(registLocationAddr);
    }

    public void setLocationArea(String locationArea) {
        this.locationArea = StringUtils.trim(locationArea);
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = StringUtils.trim(locationCity);
    }

    public void setLocationAddr(String locationAddr) {
        this.locationAddr = StringUtils.trim(locationAddr);
    }

    public void setCompanyPhone(String companyPhone) {
        this.companyPhone = StringUtils.trim(companyPhone);
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = StringUtils.trim(businessScope);
    }

    public void setManagerLocation(String managerLocation) {
        this.managerLocation = StringUtils.trim(managerLocation);
    }

    public void setManagerName(String managerName) {
        this.managerName = StringUtils.trim(managerName);
    }

    public void setManagerCardType(String managerCardType) {
        this.managerCardType = StringUtils.trim(managerCardType);
    }

    public void setManagerIdCard(String managerIdCard) {
        this.managerIdCard = StringUtils.trim(managerIdCard);
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = StringUtils.trim(managerPhone);
    }

    public void setProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = StringUtils.trim(proxyManagerName);
    }

    public void setProxyManagerCardType(String proxyManagerCardType) {
        this.proxyManagerCardType = StringUtils.trim(proxyManagerCardType);
    }

    public void setProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = StringUtils.trim(proxyManagerIdCard);
    }

    public void setProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = StringUtils.trim(proxyManagerPhone);
    }

    public void setBankName(String bankName) {
        this.bankName = StringUtils.trim(bankName);
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = StringUtils.trim(bankBranchName);
    }

    public void setBankNo(String bankNo) {
        this.bankNo = StringUtils.trim(bankNo);
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = StringUtils.trim(companyCode);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }
}
