package com.xforceplus.business.excel.company;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author zhouxin
 */
@Getter
@Setter
@ToString
public class CompanyPackageDTO extends DataRow {

    /**
     * 操作
     */
    @ExcelProperty(value = "操作")
    protected String action;
    private String tenantName;
    @NotBlank(message = "租户代码不能为空")
    @ExcelProperty("租户代码")
    private String tenantCode;


    @NotBlank(message = "公司税号不能为空")
    @ExcelProperty("统一社会信用代码")
    private String taxNum;

    private String companyName;

    private String statusName;

    @NotBlank(message = "服务包code不能为空")
    @ExcelProperty("产品服务包代码")
    private String packageCode;

    private String packageName;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setTenantName(String tenantName) {
        this.tenantName = StringUtils.trim(tenantName);
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = StringUtils.trim(tenantCode);
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setStatusName(String statusName) {
        this.statusName = StringUtils.trim(statusName);
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = StringUtils.trim(packageCode);
    }

    public void setPackageName(String packageName) {
        this.packageName = StringUtils.trim(packageName);
    }
}
