package com.xforceplus.business.excel.company;


import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.validation.constraints.StringInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author dhy
 */
@Getter
@Setter
@ToString
public class CompanyUpdateImportDto extends DataRow {

    /**
     * 操作
     */
    @ExcelProperty(value = "更新值")
    @NotBlank(message = "更新值不能为空")
    @StringInclude(message = "操作 应该为:{\"公司名称\",\"统一社会信用代码\"}", range = {"公司名称", "统一社会信用代码"})
    protected String action;

    @ExcelProperty(value = "更新后公司名称")
    private String companyName;

    @ExcelProperty("原公司名称")
    private String oldCompanyName;

    @ExcelProperty("更新后统一社会信用代码")
    private String taxNum;

    @ExcelProperty("原统一社会信用代码")
    @NotBlank(message = "原统一社会信用代码不能为空，是唯一约束条件")
    private String oldTaxNum;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setOldCompanyName(String oldCompanyName) {
        this.oldCompanyName = StringUtils.trim(oldCompanyName);
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = StringUtils.trim(taxNum);
    }

    public void setOldTaxNum(String oldTaxNum) {
        this.oldTaxNum = StringUtils.trim(oldTaxNum);
    }
}
