package com.xforceplus.business.excel.company;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @Author: HWT
 * @Date: 2020/9/24 19:45
 */
@Setter
@Getter
@ToString
public class OrgCompanyNumberDTO extends DataRow {

    /**
     * 操作
     */
    @ExcelProperty(value = "操作")
    protected String action;

    @ExcelProperty(value = "组织代码")
    @NotBlank(message = "组织代码不能为空")
    private String orgCode;

    @ExcelProperty(value = "公司编号")
    @NotBlank(message = "公司编号不能为空")
    private String companyNumber;

    @ExcelIgnore
    private Long orgId;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = StringUtils.trim(companyNumber);
    }
}
