/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ImportFileDTO.java   2020-09-22 11-36-47
 * Author: Evan
 */
package com.xforceplus.business.excel.file;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * Title: 批量导入文件DTO
 * </p>
 * <p>
 * Description:批量导入文件DTO
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 11-36-47
 * @since V1.0
 */
@Setter
@Getter
@ToString
@SuppressWarnings("all")
public class ExcelFileDTO implements Serializable {
    /**
     * ID:{@value}
     */
    public static final String ID = "id";
    /**
     * 文件导入ID
     */
    private Long id;
    /**
     * 导入租户ID
     */
    private Long tenantId;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 导出或入导出
     */
    private Integer excelFileType;
    /**
     * 业务类型
     */
    private String businessType;
    /**
     * 导入时间
     */
    private Date createDate;
    /**
     * 处理开始时间
     */
    private Date beginDate;
    /**
     * 处理结束时间
     */
    private Date endDate;
    /**
     * 处理结束时间
     */
    private Long costTime;
    /**
     * 消息写
     */
    private String message;
    /**
     * 1 未处理，2处理中，3 处理完成
     */
    private Integer status;
    /**
     * 读取次数 默认值为0
     */
    private Integer readTime;
    /**
     * 总记录
     */
    private Integer totalSize;
    /**
     * 成功记录数
     */
    private Integer successSize;
    /**
     * 处理结果（0 待处理 1 成功, 2-部分成功， 3-失败 ）
     */
    private Integer resultState;
    /**
     * 源文件fileId
     */
    private Long sourceFileId;
    /**
     * 目标文件fileId; (即错误文件，写入Error文件)
     */
    private Long targetFileId;
    /**
     * sourceFileName
     */
    private String sourceFileName;
    /**
     * targetFileName
     */
    private String targetFileName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 创建人ID
     */
    private String createrId;
    /**
     * 更新人名称
     */
    private String createrName;
    /**
     * 创建人ID
     */
    private String updaterId;
    /**
     * 更新人名称
     */
    private String updaterName;
    /**
     * 乐观锁 (用来控制)
     */
    private Integer counter;
    /**
     * 每批处理的数据，默认为：3000
     */
    private Integer batchSize;
    /**
     * 源文件路径
     */
    private String sourceFilePath;
    /**
     * 目标文件
     */
    private String targetFilePath;
    /**
     * 参数
     */
    private String params;
    /**
     * 是否重新run
     */

    private Boolean rerun = Boolean.FALSE;

    public void setBusinessType(String businessType) {
        this.businessType = StringUtils.trim(businessType);
    }

    public void setMessage(String message) {
        this.message = StringUtils.trim(message);
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = StringUtils.trim(sourceFileName);
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = StringUtils.trim(targetFileName);
    }

    public void setCreaterId(String createrId) {
        this.createrId = StringUtils.trim(createrId);
    }

    public void setCreaterName(String createrName) {
        this.createrName = StringUtils.trim(createrName);
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = StringUtils.trim(updaterId);
    }

    public void setUpdaterName(String updaterName) {
        this.updaterName = StringUtils.trim(updaterName);
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = StringUtils.trim(sourceFilePath);
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = StringUtils.trim(targetFilePath);
    }

    public void setParams(String params) {
        this.params = StringUtils.trim(params);
    }

    /**
     * 处理状态
     */
    public static class Status {
        /**
         * 待处理 {@value}
         */
        public static final int PENDING = 1;
        /**
         * 处理中  {@value}
         */
        public static final int PROCESSING = 2;
        /**
         * 完成  {@value}
         */
        public static final int FINISHED = 3;

    }

    /**
     * 结果状态
     */
    public static class ResultState {
        /**
         * 待处理 {@value}
         */
        public static final int PENDING = 0;
        /**
         * 成功的  {@value}
         */
        public static final int SUCCEED = 1;

        /**
         * 部分成功的  {@value}
         */
        public static final int PART_SUCCEED = 2;
        /**
         * 失败的  {@value}
         */
        public static final int FAILED = 3;
    }

    /**
     * 导入&导出
     */
    public static class ExcelFileType {

        /**
         * 导入功能:{@value}
         */
        public static final int IMPORT = 1;
        /**
         * 导出功能 :{@value}
         */
        public static final int EXPORT = 2;

    }

}