package com.xforceplus.business.excel.org;

import com.alibaba.excel.annotation.ExcelProperty;
import com.xforceplus.business.excel.DataRow;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * @Author: HWT
 * @Date: 2020/9/24 19:45
 */
@Setter
@Getter
@ToString
public class OrgExtensionImportDTO extends DataRow {

    /**
     * 操作
     */
    @ExcelProperty(value = "操作")
    protected String action;

    @ExcelProperty(value = "租户代码")
    @NotBlank(message = "租户代码不能为空")
    private String tenantCode;

    @ExcelProperty(value = "组织代码")
    @NotBlank(message = "组织代码不能为空")
    private String orgCode;

    @ExcelProperty(value = "key")
    @NotBlank(message = "Key不能为空")
    private String key;

    @ExcelProperty(value = "value")
    @Size(min = 1, max = 250, message = "长度范围在1~250个字符")
    @NotBlank(message = "value不能为空")
    private String value;

    public void setAction(String action) {
        this.action = StringUtils.trim(action);
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = StringUtils.trim(tenantCode);
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = StringUtils.trim(orgCode);
    }

    public void setKey(String key) {
        this.key = StringUtils.trim(key);
    }

    public void setValue(String value) {
        this.value = StringUtils.trim(value);
    }
}
