/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExclReaderUtils.java   2020-09-22 14-38-50
 * Author: Evan
 */
package com.xforceplus.business.excel.reader;

import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.service.ExcelReaderService;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * Title: ExcelReaderUtils
 * </p>
 * <p>
 * Description: ExcelReaderUtils
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 14-38-50
 * @since V1.0
 */
public class ExcelReaderUtils {
    private ExcelReaderUtils(){

    }

    /**
     * Reader
     */
    private static final Map<BusinessType, ExcelReaderService> EXCEL_READER_SERVICE_HASH_MAP = new HashMap<>();

    private static final Map<BusinessType ,Map<String,Integer>> SHEET_HEADER_MAP = new HashMap<>();

    /**
     * 获取交验器
     * @param businessType ImportBusinessType
     * @return ExcelReaderService
     */
    public static ExcelReaderService getExcelReader(BusinessType businessType) {
        if (EXCEL_READER_SERVICE_HASH_MAP.containsKey(businessType)) {
            return EXCEL_READER_SERVICE_HASH_MAP.get(businessType);
        }
        return null;
    }

    /**
     * PUT
     * @param businessType ImportBusinessType
     * @param readerService ExcelReaderService
     */
    public static void put(BusinessType businessType, ExcelReaderService readerService) {
        EXCEL_READER_SERVICE_HASH_MAP.put(businessType, readerService);
    }

    /**
     * Clear 代码
     */
    public static void clear() {
        EXCEL_READER_SERVICE_HASH_MAP.clear();
    }

    public static void putHeader( BusinessType businessType, Map<String, Integer>  headerMap){
        SHEET_HEADER_MAP.put(businessType,headerMap);
    }

    public static Map<String,Integer> getHeaderNum(BusinessType businessType){
       return SHEET_HEADER_MAP.get(businessType);
    }
}
