/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: Row.java   2020-09-22 19-08-05
 * Author: Evan
 */
package com.xforceplus.business.excel.reader;

import com.google.api.client.repackaged.com.google.common.base.Joiner;
import com.xforceplus.api.utils.Separator;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 19-08-05
 * @since V1.0
 */
@SuppressWarnings("all")
@Getter
@ToString
public class MessageRow {
    /**
     * 成功 {@value}
     */
    public static final String SUCCESS = "成功";
    /**
     * 失败 {@value}
     */
    public static final String FAIL = "失败";

    /**
     * SheetName;
     */
    private String sheetName;
    /**
     * 错误信息
     */
    private Map<Integer, Row> rows;


    public MessageRow(String sheetName) {
        this.sheetName = sheetName;
        this.rows = new HashMap<>();
    }

    /**
     * 失败
     * @param index 失败
     * @param message 失败
     * @return MessageRows
     */
    public MessageRow fail(Integer index, String message) {
        this.row(index, FAIL, message);
        return this;
    }

    /**
     * 合并错误消息
     *
     * @param rows
     */
    public void putAll(Map<Integer, Row> rows) {
        this.rows.putAll(rows);
    }

    /**
     * 获取其它
     * @return Map<Integer, Row>
     */
    public Map<Integer, Row> getRows() {
        return rows;
    }

    /**
     * 失败
     * @param index 失败
     * @return MessageRows
     */
    public MessageRow success(Integer index) {
        this.row(index, SUCCESS, StringUtils.EMPTY);
        return this;
    }

    /**
     * 添加Row
     *
     * @param index   Index
     * @param status  状态
     * @param message 消息
     */
    private synchronized void row(Integer index, String status, String message) {
        Row row;
        if (rows.containsKey(index)) {
            row = rows.get(index);
        } else {
            row = new Row();
        }
        row.setIndex(index);
        row.setStatus(status);
        row.setMessage(message);
        this.rows.put(index, row);
    }

    @ToString
    public class Row {
        /**
         * Row Index
         */
        private Integer index;
        /**
         * 一行消息
         */
        private List<String> messages;

        /**
         * 状态
         */
        private String status;

        private Row() {
            this.messages = new ArrayList<>();
            this.index = 0;
        }

        public Integer getIndex() {
            return index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getMessage() {
            Collections.sort(this.messages);
            return Joiner.on(Separator.SEMICOLON).skipNulls().join(messages);
        }

        public void setMessage(String message) {
            this.messages.add(message);
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

}
