/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelExcelBussinessType.java   2020-10-15 10-35-11
 * Author: Evan
 */
package com.xforceplus.business.excel.writer;

import com.xforceplus.business.company.service.CompanyPackageExcel;
import com.xforceplus.business.company.service.CompanyUpdateConfigExcel;
import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.tenant.excel.OrgImportExcel;
import com.xforceplus.business.tenant.service.RoleConfigExcel;
import com.xforceplus.business.tenant.service.TenantExcel;
import com.xforceplus.business.tenant.service.UserExcel;

import java.util.List;

import static com.xforceplus.business.company.service.CompanyConfigExcel.COMPANY_CONFIG_EXCEL_ATTRIBUTE;
import static com.xforceplus.business.company.service.CompanyExcel.*;
import static com.xforceplus.business.org.virtual.service.OrgVirtualConfigExcel.ORG_VIRTUAL_EXCEL_ATTRIBUTE;
import static com.xforceplus.business.org.virtual.service.OrgVirtualNodeConfigExcel.ORG_VIRTUAL_NODE_EXCEL_ATTRIBUTE;
import static com.xforceplus.business.org.virtual.service.OrgVirtualOrgStructConfigExcel.ORG_VIRTUAL_ORG_STRUCT_EXCEL_ATTRIBUTE;
import static com.xforceplus.business.resource.service.ResourceExcelConfig.*;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-15 10-35-11
 * @since V1.0
 */
public enum ExcelConfigBusinessType implements BusinessType {
    //公司信息
    COMPANY_EXCEL_FILE(COMPANY_EXCEL_ATTRIBUTE),
    //公司信息配置信息
    COMPANY_CONFIG_EXCEL_FILE(COMPANY_CONFIG_EXCEL_ATTRIBUTE),
    //批量修改公司税号和名称
    COMPANY_NAME_TAX_NUM_IMPORT(CompanyUpdateConfigExcel.ATTRIBUTE),
    //公司服务包导入
    COMPANY_PACKAGE_IMPORT(CompanyPackageExcel.ATTRIBUTE),
    //公司编号导入
    ORG_COMPANY_NUM_IMPORT(ORG_COMPANY_NUM_IMPORT_ATTRIBUTE),
    //组织公司导入
    ORG_IMPORT(OrgImportExcel.ATTRIBUTE),
    //资源码和服务API
    RESOURCE_EXCEL_FILE(ResourceServiceApiConfig.ATTRIBUTE),
    //功能集
    RESOURCE_SET_EXCEL_FILE(ResourceSetConfig.ATTRIBUTE),
    //产品服务包
    SERVICE_PACKAGE_EXCEL_FILE(ServicePackageConfig.ATTRIBUTE),
    //用户导入导出
    USER_IMPORT(UserExcel.ATTRIBUTE),
    //租户信息
    TENANT_EXCEL_FILE(TenantExcel.ATTRIBUTE),
    //角色批量绑定账号
    ROLE_BIND_ACCOUNT_IMPORT(RoleConfigExcel.ROLE_ACCOUNT_ATTRIBUTE),
    //角色信息导入
    ROLE_EXCEL_FILE(RoleConfigExcel.ROLE_ATTRIBUTE),

    //公司扩展信息导入
    ORG_EXTENSION_IMPORT(ORG_EXTENSION_IMPORT_ATTRIBUTE),

    //虚拟组织信息
    ORG_VIRTUAL_CONFIG_EXCEL_FILE(ORG_VIRTUAL_EXCEL_ATTRIBUTE),
    //虚拟组织树信息
    ORG_VIRTUAL_NODE_CONFIG_EXCEL_FILE(ORG_VIRTUAL_NODE_EXCEL_ATTRIBUTE),

    //虚拟组织导入
    ORG_VIRTUAL_IMPORT(ORG_VIRTUAL_EXCEL_ATTRIBUTE),
    //虚拟组织树导入
    ORG_VIRTUAL_NODE_IMPORT(ORG_VIRTUAL_NODE_EXCEL_ATTRIBUTE),

    //虚拟业务组织关联行政组织导入
    ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE(ORG_VIRTUAL_ORG_STRUCT_EXCEL_ATTRIBUTE),

    ;
    /**
     * 业务类型
     */
    private final BusinessAttribute attribute;


    ExcelConfigBusinessType(BusinessAttribute attribute) {
        this.attribute = attribute;
    }

    /**
     * 业务名称
     *
     * @return String
     */
    @Override
    public String getBusinessName() {
        return this.attribute.getName();
    }

    /**
     * 获取业务类型
     *
     * @return String
     */
    @Override
    public String getName() {
        return name();
    }

    /**
     * 设置每批读取大小
     * @return BatchSize
     */
    @Override
    public Integer batchSize() {
        return this.attribute.getBatchSize();
    }

    /**
     * 获取模板名称
     *
     * @return String
     */
    @Override
    public String getExportTemplateFile() {
        return this.attribute.getExportTemplateFile();
    }

    /**
     * 获取Sheets列表
     *
     * @return List<String> Sheets
     */
    @Override
    public List<ExcelSheet> sheets() {
        return this.attribute.getSheets();
    }
}
