/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelWriteUtils.java   2020-10-15 10-30-26
 * Author: Evan
 */
package com.xforceplus.business.excel.writer;

import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.service.ExcelWriteService;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-15 10-30-26
 * @since V1.0
 */
public class ExcelWriteUtils {
    private ExcelWriteUtils(){

    }

    /**
     * Reader
     */
    private static final Map<BusinessType, ExcelWriteService> EXCEL_WRITE_SERVICE_HASH_MAP = new HashMap<>();

    /**
     * 获取交验器
     * @param businessType ImportBusinessType
     * @return ExcelReaderService
     */
    public static ExcelWriteService getExcelWriter(BusinessType businessType) {
        if (EXCEL_WRITE_SERVICE_HASH_MAP.containsKey(businessType)) {
            return EXCEL_WRITE_SERVICE_HASH_MAP.get(businessType);
        }
        return null;
    }

    /**
     * PUT
     * @param businessType ImportBusinessType
     * @param excelWriteService ExcelReaderService
     */
    public static void put(BusinessType businessType, ExcelWriteService excelWriteService) {
        EXCEL_WRITE_SERVICE_HASH_MAP.put(businessType, excelWriteService);
    }

    /**
     * Clear 代码
     */
    public static void clear() {
        EXCEL_WRITE_SERVICE_HASH_MAP.clear();
    }
}
