package com.xforceplus.business.externalservice.base;

import com.xforceplus.business.externalservice.terminal.TerminalApi;
import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.client.feign.utils.FeignUtils;
import feign.Feign;
import feign.RequestInterceptor;
import feign.okhttp.OkHttpClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;


/**
 * @author geewit
 */

@Slf4j
@AutoConfigureAfter(name = {"tenantFeignConfiguration"})
@Component
public class AbstractRemoteService {

    @Value("${remote.url.terminal-service}")
    protected String terminalServiceUrl;

    @Autowired
    @Qualifier("tenantOkHttpClient")
    protected okhttp3.OkHttpClient okHttpClient;

    protected TerminalApi terminalApi;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired(required = false)
    @Qualifier("tenantTokenRequestInterceptor")
    private RequestInterceptor requestInterceptor;

    protected OkHttpClient client() {
        OkHttpClient client = new OkHttpClient(okHttpClient);
        return client;
    }

    @Autowired(required = false)
    private ClientService clientService;

    @PostConstruct
    public void init() {
        terminalApi = initTerminalApi();
    }

    private TerminalApi initTerminalApi() {

        Feign.Builder builder = FeignUtils.of(this.client(), resourceLoader, clientService);
        if (requestInterceptor != null) {
            builder.requestInterceptor(requestInterceptor);
        }
        return builder.target(TerminalApi.class, this.terminalServiceUrl);

    }
}
