package com.xforceplus.business.externalservice.terminal;

import com.xforceplus.business.externalservice.base.AbstractRemoteService;
import com.xforceplus.business.externalservice.terminal.model.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.ListUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;


/**
 * @Author: HWT
 * @Date: 2021/4/26 16:47
 */

@Service
@Slf4j
public class TerminalApiServiceImpl extends AbstractRemoteService {

    private static final int DEVICE_PAGE_SIZE = 2000;

    public Map<String, MsTerminalQueryResponseInfo> getTerminalMap(List<String> terminalList) {

        Set<String> terminalSet = new HashSet<>(terminalList);

        //分页，处理极端情况，有些人有几千个设备！！！
        List<List<String>> partitionList = ListUtils
                .partition(new ArrayList<>(terminalSet), DEVICE_PAGE_SIZE);
        Map<String, MsTerminalQueryResponseInfo> terminalQueryResponseInfoMap = new HashMap<>(
                terminalSet.size());

        for (List<String> tempList : partitionList) {
            MsConfigTemialQueryRequest queryRequest = new MsConfigTemialQueryRequest();
            MsPageInfo pageInfo = new MsPageInfo();
            pageInfo.setPageNo(1);
            pageInfo.setPageSize(tempList.size());
            queryRequest.setPageInfo(pageInfo);

            MsTerminalQueryInfo queryInfo = new MsTerminalQueryInfo();
            queryInfo.setTerminalUns(tempList);
            queryRequest.setTerminalInfo(queryInfo);
            MsQueryTerminalResponse response = null;
            try {
                response = terminalApi.getTerminalList(queryRequest);
            } catch (Exception e) {
                log.error("GetTerminalDetailError:{}", e.getMessage());
            }

            if (response != null && response.getCode() == 1) {
                if (response.getResult() != null) {
                    List<MsTerminalQueryResponseInfo> terminalResponseList = response.getResult()
                            .getTerminals();
                    if (terminalResponseList != null) {
                        terminalQueryResponseInfoMap.putAll(terminalResponseList.stream().collect(
                                Collectors.toMap(MsTerminalQueryResponseInfo::getTerminalUn, item -> item)));
                    }
                }
            } else {
                log.error("GetTerminalDetailError:{}", response);
            }
        }

        return terminalQueryResponseInfoMap;
    }

    public Map<String, MsDeviceInfo> getDeviceMap(List<String> deviceList) {

        Set<String> deviceSet = new HashSet<>(deviceList);
        Map<String, MsDeviceInfo> deviceQueryResponseInfoMap = new HashMap<>(deviceSet.size());

        //分页，处理极端情况，有些人有几千个设备！！！
        List<List<String>> partitionList = ListUtils
                .partition(new ArrayList<>(deviceSet), DEVICE_PAGE_SIZE);

        for (List<String> tempList : partitionList) {
            MsConfigDeviceQueryRequest queryRequest = new MsConfigDeviceQueryRequest();
            MsPageInfo pageInfo = new MsPageInfo();
            pageInfo.setPageNo(1);
            pageInfo.setPageSize(tempList.size());
            queryRequest.setPageInfo(pageInfo);

            MsDeviceQueryInfo queryInfo = new MsDeviceQueryInfo();
            queryInfo.setDeviceUns(tempList);
            queryRequest.setQueryInfo(queryInfo);

            MsQueryDeviceResponse response = terminalApi.getDeviceList(queryRequest);

            if (response != null && response.getCode() == 1) {
                if (response.getResult() != null) {
                    List<MsDeviceInfo> deviceResponseList = response.getResult().getDevices();
                    if (deviceResponseList != null) {
                        deviceQueryResponseInfoMap.putAll(deviceResponseList.stream()
                                .collect(Collectors.toMap(MsDeviceInfo::getDeviceUn, item -> item)));
                    }
                }
            } else {
                log.error("GetDeviceDetailError:{}", response);
            }
        }
        return deviceQueryResponseInfoMap;
    }


}
