package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 标准请求头
 */
@Setter
@Getter
@ApiModel(description = "标准请求头")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCompanyInfo {
    /**
     * 组织id
     *
     * @return organizationId
     **/
    @ApiModelProperty(value = "组织id")
    @JsonProperty("organizationId")
    private Long organizationId = null;

    /**
     * 组织名称
     *
     * @return organizationName
     **/
    @ApiModelProperty(value = "组织名称")
    @JsonProperty("organizationName")
    private String organizationName = null;

    /**
     * 租户id
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户id")
    @JsonProperty("tenantId")
    private Long tenantId = null;

    /**
     * 租户名称
     *
     * @return tenantName
     **/
    @ApiModelProperty(value = "租户名称")
    @JsonProperty("tenantName")
    private String tenantName = null;

    /**
     * 公司id
     *
     * @return companyId
     **/
    @ApiModelProperty(value = "公司id")
    @JsonProperty("companyId")
    private Long companyId = null;

    /**
     * 公司名称
     *
     * @return companyName
     **/
    @ApiModelProperty(value = "公司名称")
    @JsonProperty("companyName")
    private String companyName = null;

    /**
     * 纳税人识别号
     *
     * @return taxNo
     **/
    @ApiModelProperty(value = "纳税人识别号")
    @JsonProperty("taxNo")
    private String taxNo = null;

    public void setOrganizationName(String organizationName) {
        this.organizationName = StringUtils.trim(organizationName);
    }

    public void setTenantName(String tenantName) {
        this.tenantName = StringUtils.trim(tenantName);
    }

    public void setCompanyName(String companyName) {
        this.companyName = StringUtils.trim(companyName);
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = StringUtils.trim(taxNo);
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsCompanyInfo companyInfo = (MsCompanyInfo) o;
        return Objects.equals(this.organizationId, companyInfo.organizationId) &&
                Objects.equals(this.organizationName, companyInfo.organizationName) &&
                Objects.equals(this.tenantId, companyInfo.tenantId) &&
                Objects.equals(this.tenantName, companyInfo.tenantName) &&
                Objects.equals(this.companyId, companyInfo.companyId) &&
                Objects.equals(this.companyName, companyInfo.companyName) &&
                Objects.equals(this.taxNo, companyInfo.taxNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(organizationId, organizationName, tenantId, tenantName, companyId, companyName, taxNo);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsCompanyInfo {\n");

        sb.append("    organizationId: ").append(toIndentedString(organizationId)).append("\n");
        sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
        sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
        sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
        sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
