package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigDeviceQueryRequest
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsConfigDeviceQueryRequest {
    @JsonProperty("queryInfo")
    private MsDeviceQueryInfo queryInfo = null;

    @JsonProperty("pageInfo")
    private MsPageInfo pageInfo = null;

    @JsonProperty("sortInfo")
    private MsSortInfo sortInfo = null;

    @JsonIgnore
    public MsConfigDeviceQueryRequest queryInfo(MsDeviceQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
        return this;
    }

    /**
     * 查询信息
     *
     * @return queryInfo
     **/
    @ApiModelProperty(value = "查询信息")
    public MsDeviceQueryInfo getQueryInfo() {
        return queryInfo;
    }

    public void setQueryInfo(MsDeviceQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    @JsonIgnore
    public MsConfigDeviceQueryRequest pageInfo(MsPageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    /**
     * 分页信息
     *
     * @return pageInfo
     **/
    @ApiModelProperty(value = "分页信息")
    public MsPageInfo getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(MsPageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    @JsonIgnore
    public MsConfigDeviceQueryRequest sortInfo(MsSortInfo sortInfo) {
        this.sortInfo = sortInfo;
        return this;
    }

    /**
     * 排序信息
     *
     * @return sortInfo
     **/
    @ApiModelProperty(value = "排序信息")
    public MsSortInfo getSortInfo() {
        return sortInfo;
    }

    public void setSortInfo(MsSortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsConfigDeviceQueryRequest configDeviceQueryRequest = (MsConfigDeviceQueryRequest) o;
        return Objects.equals(this.queryInfo, configDeviceQueryRequest.queryInfo) &&
                Objects.equals(this.pageInfo, configDeviceQueryRequest.pageInfo) &&
                Objects.equals(this.sortInfo, configDeviceQueryRequest.sortInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(queryInfo, pageInfo, sortInfo);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsConfigDeviceQueryRequest {\n");

        sb.append("    queryInfo: ").append(toIndentedString(queryInfo)).append("\n");
        sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
        sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
