package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigTemialQueryRequest
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsConfigTemialQueryRequest {
    @JsonProperty("terminalInfo")
    private MsTerminalQueryInfo terminalInfo = null;

    @JsonProperty("pageInfo")
    private MsPageInfo pageInfo = null;

    @JsonProperty("sortInfo")
    private MsSortInfo sortInfo = null;

    @JsonIgnore
    public MsConfigTemialQueryRequest terminalInfo(MsTerminalQueryInfo terminalInfo) {
        this.terminalInfo = terminalInfo;
        return this;
    }

    /**
     * 终端信息
     *
     * @return terminalInfo
     **/
    @ApiModelProperty(value = "终端信息")
    public MsTerminalQueryInfo getTerminalInfo() {
        return terminalInfo;
    }

    public void setTerminalInfo(MsTerminalQueryInfo terminalInfo) {
        this.terminalInfo = terminalInfo;
    }

    @JsonIgnore
    public MsConfigTemialQueryRequest pageInfo(MsPageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    /**
     * 分页信息
     *
     * @return pageInfo
     **/
    @ApiModelProperty(value = "分页信息")
    public MsPageInfo getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(MsPageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    @JsonIgnore
    public MsConfigTemialQueryRequest sortInfo(MsSortInfo sortInfo) {
        this.sortInfo = sortInfo;
        return this;
    }

    /**
     * 排序信息
     *
     * @return sortInfo
     **/
    @ApiModelProperty(value = "排序信息")
    public MsSortInfo getSortInfo() {
        return sortInfo;
    }

    public void setSortInfo(MsSortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsConfigTemialQueryRequest configTemialQueryRequest = (MsConfigTemialQueryRequest) o;
        return Objects.equals(this.terminalInfo, configTemialQueryRequest.terminalInfo) &&
                Objects.equals(this.pageInfo, configTemialQueryRequest.pageInfo) &&
                Objects.equals(this.sortInfo, configTemialQueryRequest.sortInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(terminalInfo, pageInfo, sortInfo);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsConfigTemialQueryRequest {\n");

        sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
        sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
        sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
