package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDeviceExtraInfo {
    @JsonProperty("continuationFlag")
    private String continuationFlag = null;

    @JsonProperty("confirmInvoiceTimeout")
    private Integer confirmInvoiceTimeout = null;

    @JsonProperty("customExtra")
    private String customExtra = null;

    @JsonProperty("serverUrl")
    private String serverUrl = null;

    @JsonProperty("showMachineNoInRemarkFlag")
    private String showMachineNoInRemarkFlag = null;

    @JsonIgnore
    public MsDeviceExtraInfo continuationFlag(String continuationFlag) {
        this.continuationFlag = continuationFlag;
        return this;
    }

    /**
     * 连续开票标志，0-不连续 1-连续
     *
     * @return continuationFlag
     **/
    @ApiModelProperty(value = "连续开票标志，0-不连续 1-连续")
    public String getContinuationFlag() {
        return continuationFlag;
    }

    public void setContinuationFlag(String continuationFlag) {
        this.continuationFlag = continuationFlag;
    }

    @JsonIgnore
    public MsDeviceExtraInfo confirmInvoiceTimeout(Integer confirmInvoiceTimeout) {
        this.confirmInvoiceTimeout = confirmInvoiceTimeout;
        return this;
    }

    /**
     * 确认发票号超时时间,单位毫秒,默认：300000
     *
     * @return confirmInvoiceTimeout
     **/
    @ApiModelProperty(value = "确认发票号超时时间,单位毫秒,默认：300000")
    public Integer getConfirmInvoiceTimeout() {
        return confirmInvoiceTimeout;
    }

    public void setConfirmInvoiceTimeout(Integer confirmInvoiceTimeout) {
        this.confirmInvoiceTimeout = confirmInvoiceTimeout;
    }

    @JsonIgnore
    public MsDeviceExtraInfo customExtra(String customExtra) {
        this.customExtra = customExtra;
        return this;
    }

    /**
     * 自定义额外参数
     *
     * @return customExtra
     **/
    @ApiModelProperty(value = "自定义额外参数")
    public String getCustomExtra() {
        return customExtra;
    }

    public void setCustomExtra(String customExtra) {
        this.customExtra = customExtra;
    }

    @JsonIgnore
    public MsDeviceExtraInfo serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
     * 直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService
     *
     * @return serverUrl
     **/
    @ApiModelProperty(value = "直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService")
    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @JsonIgnore
    public MsDeviceExtraInfo showMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
        this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
        return this;
    }

    /**
     * 添加开票机号显示标志：0-在备注里加开票机号 1-不在备注里加开票机号
     *
     * @return showMachineNoInRemarkFlag
     **/
    @ApiModelProperty(value = "添加开票机号显示标志：0-在备注里加开票机号 1-不在备注里加开票机号")
    public String getShowMachineNoInRemarkFlag() {
        return showMachineNoInRemarkFlag;
    }

    public void setShowMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
        this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsDeviceExtraInfo deviceExtraInfo = (MsDeviceExtraInfo) o;
        return Objects.equals(this.continuationFlag, deviceExtraInfo.continuationFlag) &&
                Objects.equals(this.confirmInvoiceTimeout, deviceExtraInfo.confirmInvoiceTimeout) &&
                Objects.equals(this.customExtra, deviceExtraInfo.customExtra) &&
                Objects.equals(this.serverUrl, deviceExtraInfo.serverUrl) &&
                Objects.equals(this.showMachineNoInRemarkFlag, deviceExtraInfo.showMachineNoInRemarkFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(continuationFlag, confirmInvoiceTimeout, customExtra, serverUrl, showMachineNoInRemarkFlag);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsDeviceExtraInfo {\n");

        sb.append("    continuationFlag: ").append(toIndentedString(continuationFlag)).append("\n");
        sb.append("    confirmInvoiceTimeout: ").append(toIndentedString(confirmInvoiceTimeout)).append("\n");
        sb.append("    customExtra: ").append(toIndentedString(customExtra)).append("\n");
        sb.append("    serverUrl: ").append(toIndentedString(serverUrl)).append("\n");
        sb.append("    showMachineNoInRemarkFlag: ").append(toIndentedString(showMachineNoInRemarkFlag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
