package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDeviceInfo {
    @JsonProperty("deviceId")
    private Long deviceId = null;

    @JsonProperty("deviceUn")
    private String deviceUn = null;

    @JsonProperty("isQueue")
    private List<String> isQueue = new ArrayList<>();

    @JsonProperty("elQueueNames")
    private String elQueueNames = null;

    @JsonProperty("invoiceStockCheck")
    private Boolean invoiceStockCheck = false;

    @JsonProperty("invoiceStockQueues")
    private String invoiceStockQueues = null;

    @JsonProperty("assistantCheck")
    private Boolean assistantCheck = false;

    @JsonProperty("assistantQueues")
    private String assistantQueues = null;

    @JsonProperty("companyInfo")
    private MsCompanyInfo companyInfo = null;

    @JsonProperty("operateInfo")
    private MsOperateInfo operateInfo = null;

    @JsonProperty("deviceNo")
    private String deviceNo = null;

    @JsonProperty("deviceName")
    private String deviceName = null;

    @JsonProperty("deviceType")
    private String deviceType = null;

    @JsonProperty("elSubscriptionQueues")
    private String elSubscriptionQueues = null;

    @JsonProperty("fromSystem")
    private String fromSystem = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("service")
    private List<String> service = new ArrayList<>();

    @JsonProperty("taxDeviceInfo")
    private MsTaxDeviceInfo taxDeviceInfo = null;

    @JsonProperty("extraInfo")
    private MsDeviceExtraInfo extraInfo = null;

    @JsonProperty("hasLicenseFlag")
    private Boolean hasLicenseFlag = null;

    @JsonProperty("originAccountQueueName")
    private String originAccountQueueName = null;

    @JsonProperty("queueName")
    private String queueName = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonIgnore
    public MsDeviceInfo deviceId(Long deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    /**
     * 设备id，查询时返回
     *
     * @return deviceId
     **/
    @ApiModelProperty(value = "设备id，查询时返回")
    public Long getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    @JsonIgnore
    public MsDeviceInfo deviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
        return this;
    }

    /**
     * 设备唯一码
     *
     * @return deviceUn
     **/
    @ApiModelProperty(value = "设备唯一码")
    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    @JsonIgnore
    public MsDeviceInfo isQueue(List<String> isQueue) {
        this.isQueue = isQueue;
        return this;
    }

    public MsDeviceInfo addIsQueueItem(String isQueueItem) {
        this.isQueue.add(isQueueItem);
        return this;
    }

    /**
     * 是否订阅底账队列
     *
     * @return isQueue
     **/
    @ApiModelProperty(value = "是否订阅底账队列")
    public List<String> getIsQueue() {
        return isQueue;
    }

    public void setIsQueue(List<String> isQueue) {
        this.isQueue = isQueue;
    }

    @JsonIgnore
    public MsDeviceInfo elQueueNames(String elQueueNames) {
        this.elQueueNames = elQueueNames;
        return this;
    }

    /**
     * 自定义抵账队列名称
     *
     * @return elQueueNames
     **/
    @ApiModelProperty(value = "自定义抵账队列名称")
    public String getElQueueNames() {
        return elQueueNames;
    }

    public void setElQueueNames(String elQueueNames) {
        this.elQueueNames = elQueueNames;
    }

    @JsonIgnore
    public MsDeviceInfo invoiceStockCheck(Boolean invoiceStockCheck) {
        this.invoiceStockCheck = invoiceStockCheck;
        return this;
    }

    /**
     * 是否选中库存订阅
     *
     * @return invoiceStockCheck
     **/
    @ApiModelProperty(value = "是否选中库存订阅")
    public Boolean getInvoiceStockCheck() {
        return invoiceStockCheck;
    }

    public void setInvoiceStockCheck(Boolean invoiceStockCheck) {
        this.invoiceStockCheck = invoiceStockCheck;
    }

    @JsonIgnore
    public MsDeviceInfo invoiceStockQueues(String invoiceStockQueues) {
        this.invoiceStockQueues = invoiceStockQueues;
        return this;
    }

    /**
     * 库存队列（新增时为自定义库存队列，修改时为调用方库存队列+自定义库存队列）
     *
     * @return invoiceStockQueues
     **/
    @ApiModelProperty(value = "库存队列（新增时为自定义库存队列，修改时为调用方库存队列+自定义库存队列）")
    public String getInvoiceStockQueues() {
        return invoiceStockQueues;
    }

    public void setInvoiceStockQueues(String invoiceStockQueues) {
        this.invoiceStockQueues = invoiceStockQueues;
    }

    @JsonIgnore
    public MsDeviceInfo assistantCheck(Boolean assistantCheck) {
        this.assistantCheck = assistantCheck;
        return this;
    }

    /**
     * 是否选中抽取订阅
     *
     * @return assistantCheck
     **/
    @ApiModelProperty(value = "是否选中抽取订阅")
    public Boolean getAssistantCheck() {
        return assistantCheck;
    }

    public void setAssistantCheck(Boolean assistantCheck) {
        this.assistantCheck = assistantCheck;
    }

    @JsonIgnore
    public MsDeviceInfo assistantQueues(String assistantQueues) {
        this.assistantQueues = assistantQueues;
        return this;
    }

    /**
     * 库存队列（新增时为自定义库存队列，修改时为调用方库存队列+自定义库存队列）
     *
     * @return assistantQueues
     **/
    @ApiModelProperty(value = "库存队列（新增时为自定义库存队列，修改时为调用方库存队列+自定义库存队列）")
    public String getAssistantQueues() {
        return assistantQueues;
    }

    public void setAssistantQueues(String assistantQueues) {
        this.assistantQueues = assistantQueues;
    }

    @JsonIgnore
    public MsDeviceInfo companyInfo(MsCompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
        return this;
    }

    /**
     * 公司信息
     *
     * @return companyInfo
     **/
    @ApiModelProperty(value = "公司信息")
    public MsCompanyInfo getCompanyInfo() {
        return companyInfo;
    }

    public void setCompanyInfo(MsCompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    @JsonIgnore
    public MsDeviceInfo operateInfo(MsOperateInfo operateInfo) {
        this.operateInfo = operateInfo;
        return this;
    }

    /**
     * 操作信息
     *
     * @return operateInfo
     **/
    @ApiModelProperty(value = "操作信息")
    public MsOperateInfo getOperateInfo() {
        return operateInfo;
    }

    public void setOperateInfo(MsOperateInfo operateInfo) {
        this.operateInfo = operateInfo;
    }

    @JsonIgnore
    public MsDeviceInfo deviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    /**
     * 设备编号
     *
     * @return deviceNo
     **/
    @ApiModelProperty(value = "设备编号")
    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    @JsonIgnore
    public MsDeviceInfo deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    /**
     * 设备名称
     *
     * @return deviceName
     **/
    @ApiModelProperty(value = "设备名称")
    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @JsonIgnore
    public MsDeviceInfo deviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    /**
     * (必须)设备类型，taxDevice：税控设备，UKey：UKey
     *
     * @return deviceType
     **/
    @ApiModelProperty(value = "(必须)设备类型，taxDevice：税控设备，UKey：UKey")
    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @JsonIgnore
    public MsDeviceInfo elSubscriptionQueues(String elSubscriptionQueues) {
        this.elSubscriptionQueues = elSubscriptionQueues;
        return this;
    }

    /**
     * 调用方底账队列名称
     *
     * @return elSubscriptionQueues
     **/
    @ApiModelProperty(value = "调用方底账队列名称")
    public String getElSubscriptionQueues() {
        return elSubscriptionQueues;
    }

    public void setElSubscriptionQueues(String elSubscriptionQueues) {
        this.elSubscriptionQueues = elSubscriptionQueues;
    }

    @JsonIgnore
    public MsDeviceInfo fromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
        return this;
    }

    /**
     * 系统来源
     *
     * @return fromSystem
     **/
    @ApiModelProperty(value = "系统来源")
    public String getFromSystem() {
        return fromSystem;
    }

    public void setFromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
    }

    @JsonIgnore
    public MsDeviceInfo remark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
     * 备注
     *
     * @return remark
     **/
    @ApiModelProperty(value = "备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JsonIgnore
    public MsDeviceInfo service(List<String> service) {
        this.service = service;
        return this;
    }

    public MsDeviceInfo addServiceItem(String serviceItem) {
        this.service.add(serviceItem);
        return this;
    }

    /**
     * 支持的服务 （make：开票 ，print：打印，originAccount：底账）
     *
     * @return service
     **/
    @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账）")
    public List<String> getService() {
        return service;
    }

    public void setService(List<String> service) {
        this.service = service;
    }

    @JsonIgnore
    public MsDeviceInfo taxDeviceInfo(MsTaxDeviceInfo taxDeviceInfo) {
        this.taxDeviceInfo = taxDeviceInfo;
        return this;
    }

    /**
     * 税控设备消息
     *
     * @return taxDeviceInfo
     **/
    @ApiModelProperty(value = "税控设备消息")
    public MsTaxDeviceInfo getTaxDeviceInfo() {
        return taxDeviceInfo;
    }

    public void setTaxDeviceInfo(MsTaxDeviceInfo taxDeviceInfo) {
        this.taxDeviceInfo = taxDeviceInfo;
    }

    @JsonIgnore
    public MsDeviceInfo extraInfo(MsDeviceExtraInfo extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    /**
     * 配置信息
     *
     * @return extraInfo
     **/
    @ApiModelProperty(value = "配置信息")
    public MsDeviceExtraInfo getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(MsDeviceExtraInfo extraInfo) {
        this.extraInfo = extraInfo;
    }

    @JsonIgnore
    public MsDeviceInfo hasLicenseFlag(Boolean hasLicenseFlag) {
        this.hasLicenseFlag = hasLicenseFlag;
        return this;
    }

    /**
     * 是否有授权文件,查询时返回
     *
     * @return hasLicenseFlag
     **/
    @ApiModelProperty(value = "是否有授权文件,查询时返回")
    public Boolean getHasLicenseFlag() {
        return hasLicenseFlag;
    }

    public void setHasLicenseFlag(Boolean hasLicenseFlag) {
        this.hasLicenseFlag = hasLicenseFlag;
    }

    @JsonIgnore
    public MsDeviceInfo originAccountQueueName(String originAccountQueueName) {
        this.originAccountQueueName = originAccountQueueName;
        return this;
    }

    /**
     * 底账监听的队列，查询时返回
     *
     * @return originAccountQueueName
     **/
    @ApiModelProperty(value = "底账监听的队列，查询时返回")
    public String getOriginAccountQueueName() {
        return originAccountQueueName;
    }

    public void setOriginAccountQueueName(String originAccountQueueName) {
        this.originAccountQueueName = originAccountQueueName;
    }

    @JsonIgnore
    public MsDeviceInfo queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    /**
     * 开票设备监听的队列，查询时返回
     *
     * @return queueName
     **/
    @ApiModelProperty(value = "开票设备监听的队列，查询时返回")
    public String getQueueName() {
        return queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @JsonIgnore
    public MsDeviceInfo status(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）
     *
     * @return status
     **/
    @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsDeviceInfo deviceInfo = (MsDeviceInfo) o;
        return Objects.equals(this.deviceId, deviceInfo.deviceId) &&
                Objects.equals(this.deviceUn, deviceInfo.deviceUn) &&
                Objects.equals(this.isQueue, deviceInfo.isQueue) &&
                Objects.equals(this.elQueueNames, deviceInfo.elQueueNames) &&
                Objects.equals(this.invoiceStockCheck, deviceInfo.invoiceStockCheck) &&
                Objects.equals(this.invoiceStockQueues, deviceInfo.invoiceStockQueues) &&
                Objects.equals(this.companyInfo, deviceInfo.companyInfo) &&
                Objects.equals(this.operateInfo, deviceInfo.operateInfo) &&
                Objects.equals(this.deviceNo, deviceInfo.deviceNo) &&
                Objects.equals(this.deviceName, deviceInfo.deviceName) &&
                Objects.equals(this.deviceType, deviceInfo.deviceType) &&
                Objects.equals(this.elSubscriptionQueues, deviceInfo.elSubscriptionQueues) &&
                Objects.equals(this.fromSystem, deviceInfo.fromSystem) &&
                Objects.equals(this.remark, deviceInfo.remark) &&
                Objects.equals(this.service, deviceInfo.service) &&
                Objects.equals(this.taxDeviceInfo, deviceInfo.taxDeviceInfo) &&
                Objects.equals(this.extraInfo, deviceInfo.extraInfo) &&
                Objects.equals(this.hasLicenseFlag, deviceInfo.hasLicenseFlag) &&
                Objects.equals(this.originAccountQueueName, deviceInfo.originAccountQueueName) &&
                Objects.equals(this.queueName, deviceInfo.queueName) &&
                Objects.equals(this.status, deviceInfo.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceId, deviceUn, isQueue, elQueueNames, invoiceStockCheck, invoiceStockQueues, companyInfo, operateInfo, deviceNo, deviceName, deviceType, elSubscriptionQueues, fromSystem, remark, service, taxDeviceInfo, extraInfo, hasLicenseFlag, originAccountQueueName, queueName, status);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsDeviceInfo {\n");

        sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
        sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
        sb.append("    isQueue: ").append(toIndentedString(isQueue)).append("\n");
        sb.append("    elQueueNames: ").append(toIndentedString(elQueueNames)).append("\n");
        sb.append("    invoiceStockCheck: ").append(toIndentedString(invoiceStockCheck)).append("\n");
        sb.append("    invoiceStockQueues: ").append(toIndentedString(invoiceStockQueues)).append("\n");
        sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
        sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
        sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
        sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
        sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
        sb.append("    elSubscriptionQueues: ").append(toIndentedString(elSubscriptionQueues)).append("\n");
        sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
        sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
        sb.append("    service: ").append(toIndentedString(service)).append("\n");
        sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
        sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
        sb.append("    hasLicenseFlag: ").append(toIndentedString(hasLicenseFlag)).append("\n");
        sb.append("    originAccountQueueName: ").append(toIndentedString(originAccountQueueName)).append("\n");
        sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
