package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端查询结果
 * @author hwt
 */
@ApiModel(description = "终端查询结果")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsQueryDeviceResult {
    @JsonProperty("devices")
    private List<MsDeviceInfo> devices = new ArrayList<>();

    @JsonProperty("onlineDeviceIds")
    private List<Long> onlineDeviceIds = new ArrayList<>();

    @JsonProperty("onlineDeviceUns")
    private List<String> onlineDeviceUns = new ArrayList<>();

    @JsonProperty("pageInfo")
    private MsResponsePageInfo pageInfo = null;

    @JsonIgnore
    public MsQueryDeviceResult devices(List<MsDeviceInfo> devices) {
        this.devices = devices;
        return this;
    }

    public MsQueryDeviceResult addDevicesItem(MsDeviceInfo devicesItem) {
        this.devices.add(devicesItem);
        return this;
    }

    /**
     * 设备列表
     *
     * @return devices
     **/
    @ApiModelProperty(value = "设备列表")
    public List<MsDeviceInfo> getDevices() {
        return devices;
    }

    public void setDevices(List<MsDeviceInfo> devices) {
        this.devices = devices;
    }

    @JsonIgnore
    public MsQueryDeviceResult onlineDeviceIds(List<Long> onlineDeviceIds) {
        this.onlineDeviceIds = onlineDeviceIds;
        return this;
    }

    public MsQueryDeviceResult addOnlineDeviceIdsItem(Long onlineDeviceIdsItem) {
        this.onlineDeviceIds.add(onlineDeviceIdsItem);
        return this;
    }

    /**
     * 在线列表,当查询在线状态参数为true时返回
     *
     * @return onlineDeviceIds
     **/
    @ApiModelProperty(value = "在线列表,当查询在线状态参数为true时返回")
    public List<Long> getOnlineDeviceIds() {
        return onlineDeviceIds;
    }

    public void setOnlineDeviceIds(List<Long> onlineDeviceIds) {
        this.onlineDeviceIds = onlineDeviceIds;
    }

    @JsonIgnore
    public MsQueryDeviceResult onlineDeviceUns(List<String> onlineDeviceUns) {
        this.onlineDeviceUns = onlineDeviceUns;
        return this;
    }

    public MsQueryDeviceResult addOnlineDeviceUnsItem(String onlineDeviceUnsItem) {
        this.onlineDeviceUns.add(onlineDeviceUnsItem);
        return this;
    }

    /**
     * 在线列表,当查询在线状态参数为true时返回
     *
     * @return onlineDeviceUns
     **/
    @ApiModelProperty(value = "在线列表,当查询在线状态参数为true时返回")
    public List<String> getOnlineDeviceUns() {
        return onlineDeviceUns;
    }

    public void setOnlineDeviceUns(List<String> onlineDeviceUns) {
        this.onlineDeviceUns = onlineDeviceUns;
    }

    @JsonIgnore
    public MsQueryDeviceResult pageInfo(MsResponsePageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    /**
     * 分页信息
     *
     * @return pageInfo
     **/
    @ApiModelProperty(value = "分页信息")
    public MsResponsePageInfo getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(MsResponsePageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsQueryDeviceResult queryDeviceResult = (MsQueryDeviceResult) o;
        return Objects.equals(this.devices, queryDeviceResult.devices) &&
                Objects.equals(this.onlineDeviceIds, queryDeviceResult.onlineDeviceIds) &&
                Objects.equals(this.onlineDeviceUns, queryDeviceResult.onlineDeviceUns) &&
                Objects.equals(this.pageInfo, queryDeviceResult.pageInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(devices, onlineDeviceIds, onlineDeviceUns, pageInfo);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsQueryDeviceResult {\n");

        sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
        sb.append("    onlineDeviceIds: ").append(toIndentedString(onlineDeviceIds)).append("\n");
        sb.append("    onlineDeviceUns: ").append(toIndentedString(onlineDeviceUns)).append("\n");
        sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
