package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsQueryTerminalResponse
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsQueryTerminalResponse {
    @JsonProperty("code")
    private Integer code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("result")
    private MsTerminalQueryResult result = null;

    @JsonIgnore
    public MsQueryTerminalResponse code(Integer code) {
        this.code = code;
        return this;
    }

    /**
     * 返回结果状态（1：成功 0：失败）
     *
     * @return code
     **/
    @ApiModelProperty(value = "返回结果状态（1：成功 0：失败）")
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @JsonIgnore
    public MsQueryTerminalResponse message(String message) {
        this.message = message;
        return this;
    }

    /**
     * 返回信息
     *
     * @return message
     **/
    @ApiModelProperty(value = "返回信息")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public MsQueryTerminalResponse result(MsTerminalQueryResult result) {
        this.result = result;
        return this;
    }

    /**
     * 返回结果内容
     *
     * @return result
     **/
    @ApiModelProperty(value = "返回结果内容")
    public MsTerminalQueryResult getResult() {
        return result;
    }

    public void setResult(MsTerminalQueryResult result) {
        this.result = result;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsQueryTerminalResponse queryTerminalResponse = (MsQueryTerminalResponse) o;
        return Objects.equals(this.code, queryTerminalResponse.code) &&
                Objects.equals(this.message, queryTerminalResponse.message) &&
                Objects.equals(this.result, queryTerminalResponse.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsQueryTerminalResponse {\n");

        sb.append("    code: ").append(toIndentedString(code)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
