package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备信息
 */
@ApiModel(description = "设备信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsTaxDeviceInfo {
    @JsonProperty("invoiceType")
    private List<String> invoiceType = new ArrayList<>();

    @JsonProperty("taxDeviceType")
    private Integer taxDeviceType = null;

    @JsonProperty("deployType")
    private Integer deployType = null;

    @JsonProperty("taxDeviceMachineNo")
    private String taxDeviceMachineNo = null;

    @JsonProperty("taxDevicePassword")
    private String taxDevicePassword = null;

    @JsonProperty("taxDeviceDigitalPassword")
    private String taxDeviceDigitalPassword = null;

    @JsonProperty("photos")
    private List<String> photos = new ArrayList<>();

    @JsonProperty("ip")
    private String ip = null;

    @JsonProperty("port")
    private Integer port = null;

    @JsonProperty("nationalTaxPassword")
    private String nationalTaxPassword = null;

    @JsonProperty("terminalId")
    private Long terminalId = null;

    @JsonProperty("elConfirmPassword")
    private String elConfirmPassword = null;

    @JsonProperty("alwaysOnlineStartDate")
    private String alwaysOnlineStartDate = null;

    @JsonProperty("alwaysOnlineEndDate")
    private String alwaysOnlineEndDate = null;

    @JsonProperty("alwaysOnlineStartTime")
    private String alwaysOnlineStartTime = null;

    @JsonProperty("alwaysOnlineEndTime")
    private String alwaysOnlineEndTime = null;

    @JsonProperty("alwaysOnlineFlag")
    private Boolean alwaysOnlineFlag = null;

    @JsonIgnore
    public MsTaxDeviceInfo invoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    public MsTaxDeviceInfo addInvoiceTypeItem(String invoiceTypeItem) {
        this.invoiceType.add(invoiceTypeItem);
        return this;
    }

    /**
     * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
     *
     * @return invoiceType
     **/
    @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
    public List<String> getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
    }

    @JsonIgnore
    public MsTaxDeviceInfo taxDeviceType(Integer taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
        return this;
    }

    /**
     * 1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器
     *
     * @return taxDeviceType
     **/
    @ApiModelProperty(value = "1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器")
    public Integer getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(Integer taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    @JsonIgnore
    public MsTaxDeviceInfo deployType(Integer deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
     * 部署类型，1:票易通自建 2：托管 3：陈列
     *
     * @return deployType
     **/
    @ApiModelProperty(value = "部署类型，1:票易通自建 2：托管 3：陈列")
    public Integer getDeployType() {
        return deployType;
    }

    public void setDeployType(Integer deployType) {
        this.deployType = deployType;
    }

    @JsonIgnore
    public MsTaxDeviceInfo taxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
        return this;
    }

    /**
     * 开票机号
     *
     * @return taxDeviceMachineNo
     **/
    @ApiModelProperty(value = "开票机号")
    public String getTaxDeviceMachineNo() {
        return taxDeviceMachineNo;
    }

    public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
    }

    @JsonIgnore
    public MsTaxDeviceInfo taxDevicePassword(String taxDevicePassword) {
        this.taxDevicePassword = taxDevicePassword;
        return this;
    }

    /**
     * 税控盘密码
     *
     * @return taxDevicePassword
     **/
    @ApiModelProperty(value = "税控盘密码")
    public String getTaxDevicePassword() {
        return taxDevicePassword;
    }

    public void setTaxDevicePassword(String taxDevicePassword) {
        this.taxDevicePassword = taxDevicePassword;
    }

    @JsonIgnore
    public MsTaxDeviceInfo taxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
        return this;
    }

    /**
     * 税务数字证书密码
     *
     * @return taxDeviceDigitalPassword
     **/
    @ApiModelProperty(value = "税务数字证书密码")
    public String getTaxDeviceDigitalPassword() {
        return taxDeviceDigitalPassword;
    }

    public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    }

    @JsonIgnore
    public MsTaxDeviceInfo photos(List<String> photos) {
        this.photos = photos;
        return this;
    }

    public MsTaxDeviceInfo addPhotosItem(String photosItem) {
        this.photos.add(photosItem);
        return this;
    }

    /**
     * 图片
     *
     * @return photos
     **/
    @ApiModelProperty(value = "图片")
    public List<String> getPhotos() {
        return photos;
    }

    public void setPhotos(List<String> photos) {
        this.photos = photos;
    }

    @JsonIgnore
    public MsTaxDeviceInfo ip(String ip) {
        this.ip = ip;
        return this;
    }

    /**
     * ip:服务器模式时输入
     *
     * @return ip
     **/
    @ApiModelProperty(value = "ip:服务器模式时输入")
    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @JsonIgnore
    public MsTaxDeviceInfo port(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * 端口：服务器模式时输入
     *
     * @return port
     **/
    @ApiModelProperty(value = "端口：服务器模式时输入")
    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonIgnore
    public MsTaxDeviceInfo nationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
        return this;
    }

    /**
     * 国税自定义密码
     *
     * @return nationalTaxPassword
     **/
    @ApiModelProperty(value = "国税自定义密码")
    public String getNationalTaxPassword() {
        return nationalTaxPassword;
    }

    public void setNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
    }

    @JsonIgnore
    public MsTaxDeviceInfo terminalId(Long terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    /**
     * 终端id，服务器模式税控钥匙/UKey时填入
     *
     * @return terminalId
     **/
    @ApiModelProperty(value = "终端id，服务器模式税控钥匙/UKey时填入")
    public Long getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(Long terminalId) {
        this.terminalId = terminalId;
    }

    @JsonIgnore
    public MsTaxDeviceInfo elConfirmPassword(String elConfirmPassword) {
        this.elConfirmPassword = elConfirmPassword;
        return this;
    }

    /**
     * 税控统计确认密码
     *
     * @return elConfirmPassword
     **/
    @ApiModelProperty(value = "税控统计确认密码")
    public String getElConfirmPassword() {
        return elConfirmPassword;
    }

    public void setElConfirmPassword(String elConfirmPassword) {
        this.elConfirmPassword = elConfirmPassword;
    }

    @JsonIgnore
    public MsTaxDeviceInfo alwaysOnlineStartDate(String alwaysOnlineStartDate) {
        this.alwaysOnlineStartDate = alwaysOnlineStartDate;
        return this;
    }

    /**
     * 始终在线开始日期（格式：yyyyMMdd）
     *
     * @return alwaysOnlineStartDate
     **/
    @ApiModelProperty(value = "始终在线开始日期（格式：yyyyMMdd）")
    public String getAlwaysOnlineStartDate() {
        return alwaysOnlineStartDate;
    }

    public void setAlwaysOnlineStartDate(String alwaysOnlineStartDate) {
        this.alwaysOnlineStartDate = alwaysOnlineStartDate;
    }

    @JsonIgnore
    public MsTaxDeviceInfo alwaysOnlineEndDate(String alwaysOnlineEndDate) {
        this.alwaysOnlineEndDate = alwaysOnlineEndDate;
        return this;
    }

    /**
     * 始终在线结束日期（格式：yyyyMMdd）
     *
     * @return alwaysOnlineEndDate
     **/
    @ApiModelProperty(value = "始终在线结束日期（格式：yyyyMMdd）")
    public String getAlwaysOnlineEndDate() {
        return alwaysOnlineEndDate;
    }

    public void setAlwaysOnlineEndDate(String alwaysOnlineEndDate) {
        this.alwaysOnlineEndDate = alwaysOnlineEndDate;
    }

    @JsonIgnore
    public MsTaxDeviceInfo alwaysOnlineStartTime(String alwaysOnlineStartTime) {
        this.alwaysOnlineStartTime = alwaysOnlineStartTime;
        return this;
    }

    /**
     * 始终在线开始时间（格式：HHmmss）
     *
     * @return alwaysOnlineStartTime
     **/
    @ApiModelProperty(value = "始终在线开始时间（格式：HHmmss）")
    public String getAlwaysOnlineStartTime() {
        return alwaysOnlineStartTime;
    }

    public void setAlwaysOnlineStartTime(String alwaysOnlineStartTime) {
        this.alwaysOnlineStartTime = alwaysOnlineStartTime;
    }

    @JsonIgnore
    public MsTaxDeviceInfo alwaysOnlineEndTime(String alwaysOnlineEndTime) {
        this.alwaysOnlineEndTime = alwaysOnlineEndTime;
        return this;
    }

    /**
     * 始终在线结束时间（格式：HHmmss）
     *
     * @return alwaysOnlineEndTime
     **/
    @ApiModelProperty(value = "始终在线结束时间（格式：HHmmss）")
    public String getAlwaysOnlineEndTime() {
        return alwaysOnlineEndTime;
    }

    public void setAlwaysOnlineEndTime(String alwaysOnlineEndTime) {
        this.alwaysOnlineEndTime = alwaysOnlineEndTime;
    }

    @JsonIgnore
    public MsTaxDeviceInfo alwaysOnlineFlag(Boolean alwaysOnlineFlag) {
        this.alwaysOnlineFlag = alwaysOnlineFlag;
        return this;
    }

    /**
     * 始终在线标识
     *
     * @return alwaysOnlineFlag
     **/
    @ApiModelProperty(value = "始终在线标识")
    public Boolean getAlwaysOnlineFlag() {
        return alwaysOnlineFlag;
    }

    public void setAlwaysOnlineFlag(Boolean alwaysOnlineFlag) {
        this.alwaysOnlineFlag = alwaysOnlineFlag;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsTaxDeviceInfo taxDeviceInfo = (MsTaxDeviceInfo) o;
        return Objects.equals(this.invoiceType, taxDeviceInfo.invoiceType) &&
                Objects.equals(this.taxDeviceType, taxDeviceInfo.taxDeviceType) &&
                Objects.equals(this.deployType, taxDeviceInfo.deployType) &&
                Objects.equals(this.taxDeviceMachineNo, taxDeviceInfo.taxDeviceMachineNo) &&
                Objects.equals(this.taxDevicePassword, taxDeviceInfo.taxDevicePassword) &&
                Objects.equals(this.taxDeviceDigitalPassword, taxDeviceInfo.taxDeviceDigitalPassword) &&
                Objects.equals(this.photos, taxDeviceInfo.photos) &&
                Objects.equals(this.ip, taxDeviceInfo.ip) &&
                Objects.equals(this.port, taxDeviceInfo.port) &&
                Objects.equals(this.nationalTaxPassword, taxDeviceInfo.nationalTaxPassword) &&
                Objects.equals(this.terminalId, taxDeviceInfo.terminalId) &&
                Objects.equals(this.elConfirmPassword, taxDeviceInfo.elConfirmPassword) &&
                Objects.equals(this.alwaysOnlineStartDate, taxDeviceInfo.alwaysOnlineStartDate) &&
                Objects.equals(this.alwaysOnlineEndDate, taxDeviceInfo.alwaysOnlineEndDate) &&
                Objects.equals(this.alwaysOnlineStartTime, taxDeviceInfo.alwaysOnlineStartTime) &&
                Objects.equals(this.alwaysOnlineEndTime, taxDeviceInfo.alwaysOnlineEndTime) &&
                Objects.equals(this.alwaysOnlineFlag, taxDeviceInfo.alwaysOnlineFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(invoiceType, taxDeviceType, deployType, taxDeviceMachineNo, taxDevicePassword, taxDeviceDigitalPassword, photos, ip, port, nationalTaxPassword, terminalId, elConfirmPassword, alwaysOnlineStartDate, alwaysOnlineEndDate, alwaysOnlineStartTime, alwaysOnlineEndTime, alwaysOnlineFlag);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsTaxDeviceInfo {\n");

        sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
        sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
        sb.append("    deployType: ").append(toIndentedString(deployType)).append("\n");
        sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
        sb.append("    taxDevicePassword: ").append(toIndentedString(taxDevicePassword)).append("\n");
        sb.append("    taxDeviceDigitalPassword: ").append(toIndentedString(taxDeviceDigitalPassword)).append("\n");
        sb.append("    photos: ").append(toIndentedString(photos)).append("\n");
        sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
        sb.append("    port: ").append(toIndentedString(port)).append("\n");
        sb.append("    nationalTaxPassword: ").append(toIndentedString(nationalTaxPassword)).append("\n");
        sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
        sb.append("    elConfirmPassword: ").append(toIndentedString(elConfirmPassword)).append("\n");
        sb.append("    alwaysOnlineStartDate: ").append(toIndentedString(alwaysOnlineStartDate)).append("\n");
        sb.append("    alwaysOnlineEndDate: ").append(toIndentedString(alwaysOnlineEndDate)).append("\n");
        sb.append("    alwaysOnlineStartTime: ").append(toIndentedString(alwaysOnlineStartTime)).append("\n");
        sb.append("    alwaysOnlineEndTime: ").append(toIndentedString(alwaysOnlineEndTime)).append("\n");
        sb.append("    alwaysOnlineFlag: ").append(toIndentedString(alwaysOnlineFlag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
