package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsTerminalOnlineDeviceInfo {
    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("deviceName")
    private String deviceName = null;

    @JsonProperty("deviceUn")
    private String deviceUn = null;

    @JsonIgnore
    public MsTerminalOnlineDeviceInfo id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 设备id，服务器终端时返回
     *
     * @return id
     **/
    @ApiModelProperty(value = "设备id，服务器终端时返回")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public MsTerminalOnlineDeviceInfo deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    /**
     * 设备名称
     *
     * @return deviceName
     **/
    @ApiModelProperty(value = "设备名称")
    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @JsonIgnore
    public MsTerminalOnlineDeviceInfo deviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
        return this;
    }

    /**
     * 设备唯一码
     *
     * @return deviceUn
     **/
    @ApiModelProperty(value = "设备唯一码")
    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsTerminalOnlineDeviceInfo terminalOnlineDeviceInfo = (MsTerminalOnlineDeviceInfo) o;
        return Objects.equals(this.id, terminalOnlineDeviceInfo.id) &&
                Objects.equals(this.deviceName, terminalOnlineDeviceInfo.deviceName) &&
                Objects.equals(this.deviceUn, terminalOnlineDeviceInfo.deviceUn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, deviceName, deviceUn);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsTerminalOnlineDeviceInfo {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
        sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
