package com.xforceplus.business.externalservice.terminal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsTerminalQueryResponseInfo {
    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("email")
    private String email = null;

    @JsonProperty("phone")
    private String phone = null;

    @JsonProperty("fromSystem")
    private String fromSystem = null;

    @JsonProperty("deviceUn")
    private String deviceUn = null;

    @JsonProperty("companyInfo")
    private MsCompanyInfo companyInfo = null;

    @JsonProperty("operateInfo")
    private MsOperateInfo operateInfo = null;

    @JsonProperty("terminalNo")
    private String terminalNo = null;

    @JsonProperty("terminalName")
    private String terminalName = null;

    @JsonProperty("terminalType")
    private Integer terminalType = null;

    @JsonProperty("invoiceType")
    private List<String> invoiceType = new ArrayList<>();

    @JsonProperty("supportService")
    private List<String> supportService = new ArrayList<>();

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("terminalUn")
    private String terminalUn = null;

    @JsonProperty("paddingLeft")
    private Integer paddingLeft = null;

    @JsonProperty("paddingTop")
    private Integer paddingTop = null;

    @JsonProperty("printInvoiceTerminalId")
    private Long printInvoiceTerminalId = null;

    @JsonProperty("printSaleListTerminalId")
    private Long printSaleListTerminalId = null;

    @JsonProperty("onlineFlag")
    private Boolean onlineFlag = null;

    @JsonProperty("directOnlineFlag")
    private Integer directOnlineFlag = null;

    @JsonProperty("printerOnlineFlag")
    private Integer printerOnlineFlag = null;

    @JsonProperty("onlineDevices")
    private List<MsTerminalOnlineDeviceInfo> onlineDevices = new ArrayList<>();

    @JsonProperty("key")
    private String key = null;

    @JsonProperty("keyExpireAt")
    private String keyExpireAt = null;

    @JsonIgnore
    public MsTerminalQueryResponseInfo id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 终端id
     *
     * @return id
     **/
    @ApiModelProperty(value = "终端id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo email(String email) {
        this.email = email;
        return this;
    }

    /**
     * 邮箱，用于接收终端激活码
     *
     * @return email
     **/
    @ApiModelProperty(value = "邮箱，用于接收终端激活码")
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo phone(String phone) {
        this.phone = phone;
        return this;
    }

    /**
     * 手机号码，用于接收终端激活码
     *
     * @return phone
     **/
    @ApiModelProperty(value = "手机号码，用于接收终端激活码")
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo fromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
        return this;
    }

    /**
     * 调用方
     *
     * @return fromSystem
     **/
    @ApiModelProperty(value = "调用方")
    public String getFromSystem() {
        return fromSystem;
    }

    public void setFromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo deviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
        return this;
    }

    /**
     * 设备唯一码，服务器终端时返回
     *
     * @return deviceUn
     **/
    @ApiModelProperty(value = "设备唯一码，服务器终端时返回")
    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo companyInfo(MsCompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
        return this;
    }

    /**
     * 公司信息
     *
     * @return companyInfo
     **/
    @ApiModelProperty(value = "公司信息")
    public MsCompanyInfo getCompanyInfo() {
        return companyInfo;
    }

    public void setCompanyInfo(MsCompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo operateInfo(MsOperateInfo operateInfo) {
        this.operateInfo = operateInfo;
        return this;
    }

    /**
     * 操作信息
     *
     * @return operateInfo
     **/
    @ApiModelProperty(value = "操作信息")
    public MsOperateInfo getOperateInfo() {
        return operateInfo;
    }

    public void setOperateInfo(MsOperateInfo operateInfo) {
        this.operateInfo = operateInfo;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo terminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
        return this;
    }

    /**
     * 终端编号
     *
     * @return terminalNo
     **/
    @ApiModelProperty(value = "终端编号")
    public String getTerminalNo() {
        return terminalNo;
    }

    public void setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo terminalName(String terminalName) {
        this.terminalName = terminalName;
        return this;
    }

    /**
     * 终端名称
     *
     * @return terminalName
     **/
    @ApiModelProperty(value = "终端名称")
    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo terminalType(Integer terminalType) {
        this.terminalType = terminalType;
        return this;
    }

    /**
     * 终端类型 1：单盘 2：服务器
     *
     * @return terminalType
     **/
    @ApiModelProperty(value = "终端类型 1：单盘 2：服务器")
    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo invoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    public MsTerminalQueryResponseInfo addInvoiceTypeItem(String invoiceTypeItem) {
        this.invoiceType.add(invoiceTypeItem);
        return this;
    }

    /**
     * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
     *
     * @return invoiceType
     **/
    @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
    public List<String> getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo supportService(List<String> supportService) {
        this.supportService = supportService;
        return this;
    }

    public MsTerminalQueryResponseInfo addSupportServiceItem(String supportServiceItem) {
        this.supportService.add(supportServiceItem);
        return this;
    }

    /**
     * 支持的服务（print:打印 make:开票,originAccount:底账）
     *
     * @return supportService
     **/
    @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账）")
    public List<String> getSupportService() {
        return supportService;
    }

    public void setSupportService(List<String> supportService) {
        this.supportService = supportService;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo status(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）
     *
     * @return status
     **/
    @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo terminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
        return this;
    }

    /**
     * 终端唯一码
     *
     * @return terminalUn
     **/
    @ApiModelProperty(value = "终端唯一码")
    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo paddingLeft(Integer paddingLeft) {
        this.paddingLeft = paddingLeft;
        return this;
    }

    /**
     * 左边距
     *
     * @return paddingLeft
     **/
    @ApiModelProperty(value = "左边距")
    public Integer getPaddingLeft() {
        return paddingLeft;
    }

    public void setPaddingLeft(Integer paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo paddingTop(Integer paddingTop) {
        this.paddingTop = paddingTop;
        return this;
    }

    /**
     * 上边距
     *
     * @return paddingTop
     **/
    @ApiModelProperty(value = "上边距")
    public Integer getPaddingTop() {
        return paddingTop;
    }

    public void setPaddingTop(Integer paddingTop) {
        this.paddingTop = paddingTop;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo printInvoiceTerminalId(Long printInvoiceTerminalId) {
        this.printInvoiceTerminalId = printInvoiceTerminalId;
        return this;
    }

    /**
     * 打印发票终端id
     *
     * @return printInvoiceTerminalId
     **/
    @ApiModelProperty(value = "打印发票终端id")
    public Long getPrintInvoiceTerminalId() {
        return printInvoiceTerminalId;
    }

    public void setPrintInvoiceTerminalId(Long printInvoiceTerminalId) {
        this.printInvoiceTerminalId = printInvoiceTerminalId;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo printSaleListTerminalId(Long printSaleListTerminalId) {
        this.printSaleListTerminalId = printSaleListTerminalId;
        return this;
    }

    /**
     * 打印销货清单终端id
     *
     * @return printSaleListTerminalId
     **/
    @ApiModelProperty(value = "打印销货清单终端id")
    public Long getPrintSaleListTerminalId() {
        return printSaleListTerminalId;
    }

    public void setPrintSaleListTerminalId(Long printSaleListTerminalId) {
        this.printSaleListTerminalId = printSaleListTerminalId;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo onlineFlag(Boolean onlineFlag) {
        this.onlineFlag = onlineFlag;
        return this;
    }

    /**
     * 是否在线
     *
     * @return onlineFlag
     **/
    @ApiModelProperty(value = "是否在线")
    public Boolean getOnlineFlag() {
        return onlineFlag;
    }

    public void setOnlineFlag(Boolean onlineFlag) {
        this.onlineFlag = onlineFlag;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo directOnlineFlag(Integer directOnlineFlag) {
        this.directOnlineFlag = directOnlineFlag;
        return this;
    }

    /**
     * 直连功能是否在线
     *
     * @return directOnlineFlag
     **/
    @ApiModelProperty(value = "直连功能是否在线")
    public Integer getDirectOnlineFlag() {
        return directOnlineFlag;
    }

    public void setDirectOnlineFlag(Integer directOnlineFlag) {
        this.directOnlineFlag = directOnlineFlag;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo printerOnlineFlag(Integer printerOnlineFlag) {
        this.printerOnlineFlag = printerOnlineFlag;
        return this;
    }

    /**
     * 打印功能是否在线
     *
     * @return printerOnlineFlag
     **/
    @ApiModelProperty(value = "打印功能是否在线")
    public Integer getPrinterOnlineFlag() {
        return printerOnlineFlag;
    }

    public void setPrinterOnlineFlag(Integer printerOnlineFlag) {
        this.printerOnlineFlag = printerOnlineFlag;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo onlineDevices(List<MsTerminalOnlineDeviceInfo> onlineDevices) {
        this.onlineDevices = onlineDevices;
        return this;
    }

    public MsTerminalQueryResponseInfo addOnlineDevicesItem(MsTerminalOnlineDeviceInfo onlineDevicesItem) {
        this.onlineDevices.add(onlineDevicesItem);
        return this;
    }

    /**
     * 在线的设备
     *
     * @return onlineDevices
     **/
    @ApiModelProperty(value = "在线的设备")
    public List<MsTerminalOnlineDeviceInfo> getOnlineDevices() {
        return onlineDevices;
    }

    public void setOnlineDevices(List<MsTerminalOnlineDeviceInfo> onlineDevices) {
        this.onlineDevices = onlineDevices;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo key(String key) {
        this.key = key;
        return this;
    }

    /**
     * 终端激活码
     *
     * @return key
     **/
    @ApiModelProperty(value = "终端激活码")
    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @JsonIgnore
    public MsTerminalQueryResponseInfo keyExpireAt(String keyExpireAt) {
        this.keyExpireAt = keyExpireAt;
        return this;
    }

    /**
     * 终端激活码有效期
     *
     * @return keyExpireAt
     **/
    @ApiModelProperty(value = "终端激活码有效期")
    public String getKeyExpireAt() {
        return keyExpireAt;
    }

    public void setKeyExpireAt(String keyExpireAt) {
        this.keyExpireAt = keyExpireAt;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsTerminalQueryResponseInfo terminalQueryResponseInfo = (MsTerminalQueryResponseInfo) o;
        return Objects.equals(this.id, terminalQueryResponseInfo.id) &&
                Objects.equals(this.email, terminalQueryResponseInfo.email) &&
                Objects.equals(this.phone, terminalQueryResponseInfo.phone) &&
                Objects.equals(this.fromSystem, terminalQueryResponseInfo.fromSystem) &&
                Objects.equals(this.deviceUn, terminalQueryResponseInfo.deviceUn) &&
                Objects.equals(this.companyInfo, terminalQueryResponseInfo.companyInfo) &&
                Objects.equals(this.operateInfo, terminalQueryResponseInfo.operateInfo) &&
                Objects.equals(this.terminalNo, terminalQueryResponseInfo.terminalNo) &&
                Objects.equals(this.terminalName, terminalQueryResponseInfo.terminalName) &&
                Objects.equals(this.terminalType, terminalQueryResponseInfo.terminalType) &&
                Objects.equals(this.invoiceType, terminalQueryResponseInfo.invoiceType) &&
                Objects.equals(this.supportService, terminalQueryResponseInfo.supportService) &&
                Objects.equals(this.status, terminalQueryResponseInfo.status) &&
                Objects.equals(this.terminalUn, terminalQueryResponseInfo.terminalUn) &&
                Objects.equals(this.paddingLeft, terminalQueryResponseInfo.paddingLeft) &&
                Objects.equals(this.paddingTop, terminalQueryResponseInfo.paddingTop) &&
                Objects.equals(this.printInvoiceTerminalId, terminalQueryResponseInfo.printInvoiceTerminalId) &&
                Objects.equals(this.printSaleListTerminalId, terminalQueryResponseInfo.printSaleListTerminalId) &&
                Objects.equals(this.onlineFlag, terminalQueryResponseInfo.onlineFlag) &&
                Objects.equals(this.directOnlineFlag, terminalQueryResponseInfo.directOnlineFlag) &&
                Objects.equals(this.printerOnlineFlag, terminalQueryResponseInfo.printerOnlineFlag) &&
                Objects.equals(this.onlineDevices, terminalQueryResponseInfo.onlineDevices) &&
                Objects.equals(this.key, terminalQueryResponseInfo.key) &&
                Objects.equals(this.keyExpireAt, terminalQueryResponseInfo.keyExpireAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, email, phone, fromSystem, deviceUn, companyInfo, operateInfo, terminalNo, terminalName, terminalType, invoiceType, supportService, status, terminalUn, paddingLeft, paddingTop, printInvoiceTerminalId, printSaleListTerminalId, onlineFlag, directOnlineFlag, printerOnlineFlag, onlineDevices, key, keyExpireAt);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MsTerminalQueryResponseInfo {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
        sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
        sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
        sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
        sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
        sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
        sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
        sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
        sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
        sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
        sb.append("    paddingLeft: ").append(toIndentedString(paddingLeft)).append("\n");
        sb.append("    paddingTop: ").append(toIndentedString(paddingTop)).append("\n");
        sb.append("    printInvoiceTerminalId: ").append(toIndentedString(printInvoiceTerminalId)).append("\n");
        sb.append("    printSaleListTerminalId: ").append(toIndentedString(printSaleListTerminalId)).append("\n");
        sb.append("    onlineFlag: ").append(toIndentedString(onlineFlag)).append("\n");
        sb.append("    directOnlineFlag: ").append(toIndentedString(directOnlineFlag)).append("\n");
        sb.append("    printerOnlineFlag: ").append(toIndentedString(printerOnlineFlag)).append("\n");
        sb.append("    onlineDevices: ").append(toIndentedString(onlineDevices)).append("\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    keyExpireAt: ").append(toIndentedString(keyExpireAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
