package com.xforceplus.business.file.controller;

import com.alibaba.excel.util.DateUtils;
import com.xforceplus.api.common.Uri;
import com.xforceplus.business.enums.FileTemplateEnum;
import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.BasePathUtils;
import com.xforceplus.utils.DownloadUtils;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.Date;


@SuppressWarnings("all")
@Api(value = "文件处理相关接口", description = "文件相关接口")
@Validated
@Controller
@RequestMapping(Uri.PATH_GLOBAL_PREFIX)
public class FileController {
    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    /**
     * 下载文件名  yyyyMMddHHmmssSSS
     */
    private static final String DOWNLOAD_FILE_NAME = "yyyyMMddHHmmssSSS";
    @Autowired
    private FileTransferUtilsService fileTransferUtilsService;
    /**
     * 文件导入服务
     */
    @Autowired
    private ImportFileService importFileService;

    /**
     * 下载文件
     *
     * @return
     */
    @ApiOperation(value = "下载文件", notes = "下载文件")
    @RequestMapping(name = "下载文件", value = {"/file/{fileId}"}, method = RequestMethod.GET)
    public void download(@PathVariable String fileId, HttpServletRequest request,
                         HttpServletResponse response) {
        String filePath = BasePathUtils.ensureFilePath(request);
        try {
            logger.warn("下载地址：{}", filePath);
            fileTransferUtilsService.download(filePath, Long.valueOf(fileId));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new UnknownException("下载文件失败。");
        }
        //下载文件名修改为：yyyyMMddHHmmssSSS
        DownloadUtils.fileToDownload(response, filePath, DateUtils.format(new Date(), DOWNLOAD_FILE_NAME) + ExcelFile.FILE_NAME_EXT);
        this.deleteFile(filePath);
    }


    @Deprecated
    @ApiOperation(value = "下载导入模板")
    @RequestMapping(name = "下载导入模板", value = {"/file/template"}, method = RequestMethod.GET)
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, FileTemplateEnum.Template template) {
        String filePath = BasePathUtils.getTemplatePath(request, "templates", template.fileName());
        DownloadUtils.fileToDownload(response, filePath, template.targetName());
    }

    @ApiOperation(value = "下载批量导入模板")
    @RequestMapping(name = "下载批量导入模板", value = {"/file/batchImportTemplate"}, method = RequestMethod.GET)
    public void importTemplate(HttpServletRequest request, HttpServletResponse response, FileTemplateEnum.BatchImportTemplate template) {
        String filePath = BasePathUtils.getTemplatePath(request, "templates/batch", template.fileName());
        DownloadUtils.fileToDownload(response, filePath, template.targetName());
    }

    /**
     * 删除文件
     * @param filePath
     */
    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            logger.info("删除文件结果:{}", deleteResult);
        }
    }

}
