/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelFileStoreQueryVo.java   2020-10-16 15-58-33
 * Author: Evan
 */
package com.xforceplus.business.file.controller.vo;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * <p>
 * Title: 查询列表请求参数
 * </p>
 * <p>
 * Description: 查询列表请求参数
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-16 15-58-33
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class ExcelFileStorePageReqVo implements Serializable {
    /**
     * 导出或入导出
     */
    private Integer excelFileType;

    /**
     * 业务类型
     */
    private String businessType;


    /**
     * 1 未处理，2处理中，3 处理完成
     */
    private Integer status;

    /**
     * 处理结果（0 待处理 1 成功, 2-部分成功， 3-失败 ）
     */
    private Integer resultState;
}