/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ExcelFileStoreQueryRespVo.java   2020-10-16 15-59-13
 * Author: Evan
 */
package com.xforceplus.business.file.controller.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * Title: 查询列表
 * </p>
 * <p>
 * Description: 查询列表
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-16 15-59-13
 * @since V1.0
 */
@Getter
@Setter
@ToString
public class ExcelFileStorePageRespVo implements Serializable {
    /**
     * 文件导入ID
     */
    private Long id;
    /**
     * 导入租户ID
     */
    private Long tenantId;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 导出或入导出
     */
    private Integer excelFileType;
    /**
     * 业务类型
     */
    private String businessType;
    /**
     * 业务类型
     */
    private String businessName;
    /**
     * 导入时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    /**
     * 处理开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date beginDate;
    /**
     * 处理结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endDate;

    /**
     * 处理结束时间
     */
    private Long costTime;

    /**
     * 消息写
     */
    private String message;

    /**
     * 1 未处理，2处理中，3 处理完成
     */
    private Integer status;

    /**
     * 读取次数 默认值为0
     */
    private Integer readTime;

    /**
     * 总记录
     */
    private Integer totalSize;
    /**
     * 成功记录数
     */
    private Integer successSize;
    /**
     * 处理结果（0 待处理 1 成功, 2-部分成功， 3-失败 ）
     */
    private Integer resultState;
    /**
     * 源文件fileId
     */
    private Long sourceFileId;
    /**
     * 目标文件fileId; (即错误文件，写入Error文件)
     */
    private Long targetFileId;

    /**
     * sourceFileName
     */
    private String sourceFileName;

    /**
     * targetFileName
     */
    private String targetFileName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 文件是否在效期内
     */
    private Boolean expired;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 创建人ID
     */
    private String createrId;
    /**
     * 更新人名称
     */
    private String createrName;
    /**
     * 创建人ID
     */
    private String updaterId;
    /**
     * 更新人名称
     */
    private String updaterName;
    /**
     * 每批处理的数据，默认为：3000
     */
    private Integer batchSize;

}
