package com.xforceplus.business.file.service;


import com.alibaba.fastjson.JSON;
import com.xforceplus.utils.excel.ExcelUtils;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.*;

@Service("sysFileService")
@Slf4j
public class FileService {


    @Autowired
    private FileTransferUtilsService fileTransferUtilsService;

    public Long uploadMsgExcel(List<String> errorMsgs) {
        if (CollectionUtils.isNotEmpty(errorMsgs)) {
            String filePath = "";
            try {
                List<Map<String, String>> rows = new ArrayList<>();
                for (String errorMsg : errorMsgs) {
                    Map<String, String> row = new LinkedHashMap<>();
                    row.put("key", errorMsg);
                    rows.add(row);
                }
                Map<String, String> rules = new HashMap<>(2);
                rules.put("key", "导入错误信息");
                String sheetName = "导入错误信息";
                String json = JSON.toJSONString(rows);
                filePath = ExcelUtils.buildExcelFile(json, rules, sheetName);

                return fileTransferUtilsService.upload(filePath);
            } catch (FileNotFoundException e) {
                log.error("错误信息上传oss失败,{}", filePath);
            }
        }
        return null;
    }

    public Long exportDataExcel(String json, Map<String, String> rules, String sheetName) {
        String filePath = "";
        try {
            filePath = ExcelUtils.buildExcelFile(json, rules, sheetName);
            log.info("excel path=={}", filePath);
        } catch (Exception e) {
            log.error("转excel失败,{}", filePath);
        }
        try {
            return fileTransferUtilsService.upload(filePath);
        } catch (FileNotFoundException e) {
            log.error("导出信息上传文件服务失败,{}", filePath);
        } finally {
            this.deleteFile(filePath);
        }
        return null;
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            log.info("删除文件：{},结果:{}", filePath, deleteResult);
        }
    }
}
