package com.xforceplus.business.id.controller;

import com.google.common.base.Splitter;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.IdGeneratorApi;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(value = "id相关接口", tags = "id相关接口")
@Controller
public class IdGeneratorController implements IdGeneratorApi {
    private static final Logger logger = LoggerFactory.getLogger(IdGeneratorController.class);
    private static final int QUANTITY = 100;

    @Override
    public ResponseEntity<List<Long>> generate(int quantity, String entityName) {
        if (quantity == 0) {
            quantity = 1;
        }
        logger.info("quantity = " + quantity);
        if (quantity > QUANTITY) {
            throw new IllegalArgumentException("quantity 非法!");
        }
        List<Long> ids = new ArrayList<>(quantity);
        for (int i = 0; i < quantity; i++) {

            long id = SnowflakeGenerator.id(entityName);
            logger.info("id = " + id);
            ids.add(i, id);
        }
        return ResponseEntity.ok(ids);
    }

    @Override
    public ResponseEntity<Map<String, List<Long>>> generateIdMap(int quantity, String entityNames) {
        if (quantity == 0) {
            quantity = 1;
        }
        logger.info("quantity = " + quantity);
        if (quantity > QUANTITY) {
            throw new IllegalArgumentException("quantity 非法!");
        }

        List<String> entityNameList = Splitter.on(",").trimResults().splitToList(entityNames);
        if (entityNameList == null || entityNameList.isEmpty()) {
            throw new IllegalArgumentException("entity name 不能为空");
        }
        Map<String, List<Long>> idMap = new HashMap<>(entityNameList.size());
        for (String entityName : entityNameList) {
            List<Long> ids = new ArrayList<>(quantity);
            for (int i = 0; i < quantity; i++) {
                long id = SnowflakeGenerator.id(entityName);
                logger.info("id = " + id);
                ids.add(i, id);
            }
            idMap.put(entityName, ids);
        }

        return ResponseEntity.ok(idMap);
    }
}
