package com.xforceplus.business.message.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.message.MessageApi;
import com.xforceplus.business.message.service.MessageService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@SuppressWarnings("all")
@RestController
@Slf4j
public class MessageController implements MessageApi {

    @Autowired
    private MessageService messageService;

    @AuthorizedDefinition(authentication = false)
    @Override
    public ResponseEntity<String> sendAuthCode(String phoneOrEmail, Integer type) {
        log.info("发送验证码: phoneOrEmail = {}, type = {}", phoneOrEmail, type);
        String msgId;
        if (type == 0) {
            msgId = messageService.sendAuthSmsCode(phoneOrEmail);
        } else if (type == 1) {
            msgId = messageService.sendAuthEmailCode(phoneOrEmail);
        } else {
            throw new IllegalArgumentException(String.format("type = [%s] 不支持", type));
        }
        return ResponseEntity.ok(msgId);
    }

    @AuthorizedDefinition(authentication = false)
    @Override
    public ResponseEntity<Boolean> checkAuthCode(String msgId, String captcha, String phoneOrEmail, Integer type) {
        log.info("验证验证码: phoneOrEmail = {}, type = {}, msgId = {}, captcha = {}",
                phoneOrEmail, type, msgId, captcha);
        boolean result;

        if (type == 0) {
            result = messageService.checkAuthSmsCode(captcha, phoneOrEmail, msgId);
        } else if (type == 1) {
            result = messageService.checkAuthEmailCode(captcha, phoneOrEmail, msgId);
        } else {
            throw new IllegalArgumentException(String.format("type = [%s] 不支持", type));
        }
        return ResponseEntity.ok(result);
    }

}
