package com.xforceplus.business.message.service;


import com.xforceplus.feign.tenant.message.EmailAuthCodeFeignClient;
import com.xforceplus.feign.tenant.message.SmsAuthCodeFeignClient;
import com.xforceplus.utils.PropertiesUtils;
import com.xforececlound.message.model.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageService {

    @Autowired
    private EmailAuthCodeFeignClient emailAuthCodeFeignClient;
    @Autowired
    private SmsAuthCodeFeignClient smsAuthCodeFeignClient;


    private Long getTenantId() {
        return 0L;
    }


    public String sendAuthEmailCode(String email) {
        Long tenantId = this.getTenantId();

        EmailAuthCodeReq emailAuthCodeReq = new EmailAuthCodeReq();
        emailAuthCodeReq.setAppId(1L);
        emailAuthCodeReq.setEmail(email);
        emailAuthCodeReq.setTemplateCode(PropertiesUtils.EMAIL_CHANGE_PHONE);
        emailAuthCodeReq.setTenantId(tenantId);
        emailAuthCodeReq.setExpireTime(3);
        AuthCodeResp resp = emailAuthCodeFeignClient.sendAuthCode(String.valueOf(tenantId), emailAuthCodeReq);

        if (resp == null) {
            throw new IllegalArgumentException("发送验证码失败。");
        } else if (resp.getCode() != 1) {
            throw new IllegalArgumentException(resp.getDesc());
        }
        return resp.getMsgId();
    }

    public String sendAuthSmsCode(String phone) {
        Long tenantId = this.getTenantId();
        SmsCodeReq smsCodeReq = new SmsCodeReq();
        smsCodeReq.setMobile(phone);
        smsCodeReq.setSignName("票税助手");
        smsCodeReq.setTemplateCode(PropertiesUtils.SMS_CHANGE_PHONE);
        smsCodeReq.setTenantId(tenantId);

        AuthCodeResp resp = smsAuthCodeFeignClient.sendAuthCode(String.valueOf(tenantId), smsCodeReq);
        if (resp == null) {
            throw new IllegalArgumentException("发送验证码失败。");
        } else if (resp.getCode() != 1) {
            throw new IllegalArgumentException(resp.getDesc());
        }
        return resp.getMsgId();
    }


    public boolean checkAuthEmailCode(String captcha, String email, String msgId) {

        Long tenantId = this.getTenantId();
        EmailValidateReq emailValidateReq = new EmailValidateReq();
        emailValidateReq.setCode(captcha);
        emailValidateReq.setEmail(email);
        emailValidateReq.setMsgId(msgId);

        SmsValidateResp resp = emailAuthCodeFeignClient.validate(tenantId + "", emailValidateReq);
        if (null == resp || !resp.isCheck()) {
            return false;
        }
        return true;
    }

    public boolean checkAuthSmsCode(String captcha, String phone, String msgId) {
        Long tenantId = this.getTenantId();
        SmsValidateReq smsValidateReq = new SmsValidateReq();
        smsValidateReq.setCode(captcha);
        smsValidateReq.setMobile(phone);
        smsValidateReq.setMsgId(msgId);

        SmsValidateResp resp = smsAuthCodeFeignClient.validate(tenantId + "", smsValidateReq);
        if (null == resp || !resp.isCheck()) {
            return false;
        }
        return true;

    }

}
