/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyServicePackagePubService.java   2021-01-14 11-47-12
 * Author: Evan
 */
package com.xforceplus.business.messagebus;

import com.xforceplus.api.model.CompanyServiceRelModel;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.ServicePackage;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * Title: 公司服务包绑定关系消息发布服务
 * </p>
 * <p>
 * Description: 公司服务包绑定关系（发布到MQ）
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-14 11-47-12
 * @since V1.0
 */
public interface CompanyServicePackagePubService {

    /**
     * 公司服务包 pub
     * @param channelId 渠道id
     * @param tenantModel 租户信息
     * @param companyServiceModels 公司服务包信息
     */
    void sendMessage(String channelId, CompanyServiceRelModel.Response.TenantModel tenantModel,
                     List<CompanyServiceRelModel.Response.CompanyServiceModel> companyServiceModels);


    /**
     * 构造消息
     * @param servicePackageMap 服务包map
     * @param companyMap  公司map
     * @param resl 公司服务集合
     * @param operation 操作
     * @return
     */
    List<CompanyServiceRelModel.Response.CompanyServiceModel> buildCompanyServiceMessage(Map<Long, ServicePackage> servicePackageMap, Map<Long, Company> companyMap,
                                                                                         Set<CompanyServiceRel> resl, String operation);

}
