package com.xforceplus.business.messagebus.bus;

import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.janus.message.sdk.RequestMessage;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import io.geewit.web.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * @author duanhy
 */
@SuppressWarnings("all")
@ConditionalOnProperty(prefix = "pubsub", name = "enable", havingValue = "true")
@Service
public class MessageBusService {
    private static Logger logger = LoggerFactory.getLogger(MessageBusService.class);

    private MBClient client;

    @Value("${remote.message.bus.server.url:}")
    private String url;

    @Value("${remote.message.bus.server.token:}")
    private String token;

    @PostConstruct
    public void init() {
        try {
            client = MBClient.getInstance(url,token);
        } catch (Exception e) {
            logger.warn("message bus connect error", e);
        }
    }


    /**
     * @param requestName 订阅业务类型，业务类型由数据发布方定义
     * @param message     消息体
     * @param tagkvs      标签字段与字段值
     */
    public String sendMessage(String requestName, String content, Map<String, String> tagkvs) {
        logger.info("xforce.message.bus.requestName={},tagkvs={},content={}", requestName,JsonUtils.toJson(tagkvs),content);
        try {
            RequestMessage requestMessage = new RequestMessage();
            requestMessage.setContent(content);
            requestMessage.addProperties(tagkvs);
            requestMessage.setSentTime(System.currentTimeMillis());
            PubRequest pubRequest = new PubRequest(requestName,requestMessage);
            PubResponse pub = client.pub(pubRequest);
            if(!pub.getSuccess()){
                logger.error("send_message_error,error:{}",pub);
            }
            return JsonUtils.toJson(pub);
        } catch (Exception e) {
            logger.error("message bus sendMessage messahe bus error", e);
            return null;
        }
    }

}
