/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: AccountPubSubServiceImpl.java   2021-01-13 14-54-43
 * Author: Evan
 */
package com.xforceplus.business.messagebus.impl;

import com.xforceplus.business.account.dto.AccountPubDTO;
import com.xforceplus.business.messagebus.AccountPubSubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.entity.Account;
import io.geewit.web.utils.JsonUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.apache.commons.lang3.StringUtils.defaultIfEmpty;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-13 14-54-43
 * @since V1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class AccountPubSubServiceImpl implements AccountPubSubService {

    /**
     * 渠道-ALL
     */
    public static final String PARAM_CHANNEL = "channel";
    /**
     * 渠道默认值==ALL
     */
    public static final String CHANNEL_DEFAULT_VALUE = "ALL";
    @Value("${xforce.pub.account:xforce.tenant.account}")
    private String code;

    private final MessageBusAsyncService messageBusAsyncService;


    /**
     * 发布账号订阅消息
     *
     * @param account Account
     */
    @Override
    @Async("threadPoolExecutor")
    public void publish(Account account) {
        if (StringUtils.isEmpty(code)) {
            log.warn("AccountPubDTO pubCode为空，暂不发消息");
            return;
        }
        if (account == null) {
            log.warn("账信息为空，不执行账户消息发送");
            return;
        }
        log.info("account:{}", account.toString());

        AccountPubDTO pubDTO = new AccountPubDTO();
        pubDTO.setAccountId(account.getAccountId());
        pubDTO.setEmail(defaultIfEmpty(account.getEmail(), EMPTY));
        pubDTO.setTelPhone(defaultIfEmpty(account.getTelPhone(), EMPTY));
        pubDTO.setUsername(defaultIfEmpty(account.getUsername(), EMPTY));
        pubDTO.setChannel(CHANNEL_DEFAULT_VALUE);
        //发送消息
        log.info("AccountPubDTO:{}", pubDTO);

        Map<String, String> tagkvs = new HashMap<>();
        tagkvs.put("businessNo", account.getAccountId().toString());
        tagkvs.put(PARAM_CHANNEL, pubDTO.getChannel());

        String content = JsonUtils.toJson(pubDTO);

        messageBusAsyncService.sendMessage(code,tagkvs,content);
    }
}
